<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Coaches extends My_Controller {

	public function index()
	{
      $coaches = $this->db->query('select * from user where usertypeid = 3 and deleted is null order by surname, firstname');
      $this->load->view('coaches/view_coaches',
         array('current' => 'coaches',
               'coaches' => $coaches      
      ));
	}
   
   public function edit()
   {
      if($this->uri->segment(3) == '')
         $coachid = '';
      else
         $coachid = decuri($this->uri->segment(3));
         
      if($this->input->post('formpost'))
      {
         $coachid = $this->input->post('coachid');
         if($coachid == '')
         {
            $rs = $this->db->query('select * from user where username = ?',array($this->input->post('username')));
            if($rs->num_rows() != 0)
               error_msg('Another user with the same username already exists.');
            else
            {        
               if($this->input->post('password') != $this->input->post('confirmpassword'))
                  error_msg('Your passwords do not match!');    
               else
               {
                  $this->db->query('insert into user (usertypeid, username, password, firstname, surname, tel, cell, email, 
                                    idnumber, relativename, relativetel, relativecell, relativeemail, physicaladdress1, physicaladdress2,
                                    physicalsuburb, physicalcity, physicalprovince, physicalcode, postaladdress1, postaladdress2,
                                    postalsuburb, postalprovince, postalcity, postalcode, medicalaidname, medicalaidscheme, medicalaidnumber,
                                    bankname, branchname, branchnumber, accountname, accountnumber, createdon, createdbyuserid) 
                                    values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP,?)',
                                    array($this->input->post('usertype'),                           
                                       $this->input->post('username'),
                                       $this->input->post('password'),
                                       $this->input->post('firstname'),
                                       $this->input->post('surname'),
                                       $this->input->post('tel'),
                                       $this->input->post('cell'),
                                       $this->input->post('email'),
                                       $this->input->post('idnumber'),
                                       $this->input->post('relativename'),
                                       $this->input->post('relativetel'),
                                       $this->input->post('relativecell'),
                                       $this->input->post('relativeemail'),
                                       $this->input->post('physicaladdress1'),
                                       $this->input->post('physicaladdress2'),
                                       $this->input->post('physicalsuburb'),
                                       $this->input->post('physicalcity'),
                                       $this->input->post('physicalprovince'),
                                       $this->input->post('physicalcode'),
                                       $this->input->post('postaladdress1'),
                                       $this->input->post('postaladdress2'),
                                       $this->input->post('postalsuburb'),
                                       $this->input->post('postalprovince'),
                                       $this->input->post('postalcity'),
                                       $this->input->post('postalcode'),
                                       $this->input->post('medicalaidname'),
                                       $this->input->post('medicalaidscheme'),
                                       $this->input->post('medicalaidnumber'),
                                       $this->input->post('bankname'),
                                       $this->input->post('branchname'),
                                       $this->input->post('branchnumber'),
                                       $this->input->post('accountname'),
                                       $this->input->post('accountnumber'),
                                       user()->userid                          
                  ));
                  success_msg('Coach added successfully!');         
                  header('Location: /coaches');
                  exit;
               }
            }
         }
         else
         {
            if($this->input->post('password') != $this->input->post('confirmpassword'))
               error_msg('Your passwords do not match!');
            else
            {
               $this->db->query('update user set
                              usertypeid = ?,
                              username = ?,
                              password = ?,
                              firstname = ?,
                              surname = ?,
                              tel = ?,
                              cell = ?,
                              email = ?,
                              idnumber = ?,
                              relativename = ?,
                              relativetel = ?,
                              relativecell = ?,
                              relativeemail = ?,
                              physicaladdress1 = ?,
                              physicaladdress2 = ?,
                              physicalsuburb = ?,
                              physicalcity = ?,
                              physicalprovince = ?,
                              physicalcode = ?,
                              postaladdress1 = ?,
                              postaladdress2 = ?,
                              postalsuburb = ?,
                              postalprovince = ?,
                              postalcity = ?,
                              postalcode = ?,
                              medicalaidname = ?,
                              medicalaidscheme = ?,
                              medicalaidnumber = ?,
                              bankname = ?,
                              branchname = ?,
                              branchnumber = ?,
                              accountname = ?,
                              accountnumber = ?,
                              updatedon = CURRENT_TIMESTAMP,
                              updatedbyuserid = ?
                              where userid = ?',
                              array($this->input->post('usertype'),                           
                                    $this->input->post('username'),
                                    $this->input->post('password'),
                                    $this->input->post('firstname'),
                                    $this->input->post('surname'),
                                    $this->input->post('tel'),
                                    $this->input->post('cell'),
                                    $this->input->post('email'),
                                    $this->input->post('idnumber'),
                                    $this->input->post('relativename'),
                                    $this->input->post('relativetel'),
                                    $this->input->post('relativecell'),
                                    $this->input->post('relativeemail'),
                                    $this->input->post('physicaladdress1'),
                                    $this->input->post('physicaladdress2'),
                                    $this->input->post('physicalsuburb'),
                                    $this->input->post('physicalcity'),
                                    $this->input->post('physicalprovince'),
                                    $this->input->post('physicalcode'),
                                    $this->input->post('postaladdress1'),
                                    $this->input->post('postaladdress2'),
                                    $this->input->post('postalsuburb'),
                                    $this->input->post('postalprovince'),
                                    $this->input->post('postalcity'),
                                    $this->input->post('postalcode'),
                                    $this->input->post('medicalaidname'),
                                    $this->input->post('medicalaidscheme'),
                                    $this->input->post('medicalaidnumber'),
                                    $this->input->post('bankname'),
                                    $this->input->post('branchname'),
                                    $this->input->post('branchnumber'),
                                    $this->input->post('accountname'),
                                    $this->input->post('accountnumber'),
                                    user()->userid,
                                    $coachid                           
               ));         
            
               success_msg('Coach updated successfully!');       
               header('Location: /coaches');
               exit;  
            }
         }
      }
      
      $user = null;
      
      if($coachid != '')
      {
         $user = $this->db->query('select * from user where userid = ?',array($coachid));
         $pagetitle = 'Edit Coach';
      }
      else
         $pagetitle = 'New Coach';
      
      $this->load->view('coaches/view_edit_coach',
         array('current' => 'coaches',
               'pagetitle' => $pagetitle,
               'user' => $user,
               'coachid' => $coachid
      ));
      
   }
   
   public function delete()
   {
      $coachid = decuri($this->uri->segment(3));
      $this->db->query('delete from user where userid = ?',array($coachid));
      success_msg('Coach deleted!');
      header('Location: /coaches');
   }
   
   public function masslink()
   {
      $coachid = decuri($this->uri->segment(3));
      $schoolid = decuri($this->uri->segment(4));
      
      if($this->input->post('formpost'))
      {
         $coachid = $this->input->post('coachid');
         $schoolid = $this->input->post('schoolid');
         
         if($this->input->post('sessionlink') == '1')
         {
            if($this->input->post('sessionid') == '')
               error_msg('Please select the session to link to.');
            else
            {
               $this->db->query('update session set coachid = ? where sessionid = ?',array($coachid,$this->input->post('sessionid')));
               success_msg('Coach linked!');
               header('Location: /coaches');
               exit;
            }
         }
         else
         {
            $this->db->query('delete from schoollink where schoolid = ? and userid = ?',
               array($this->input->post('schoolid'),
                     $this->input->post('coachid')         
            ));
            $this->db->query('insert schoollink (schoolid, userid) values(?,?)',
               array($this->input->post('schoolid'),
                     $this->input->post('coachid')
            ));
            success_msg('Coach linked!');
            header('Location: /coaches');
            exit;            
         }
      }
      
      $coach = $this->db->query('select firstname, surname from user where userid = ?',array($coachid));
      $school = $this->db->query('select schoolname from school where schoolid = ?',array($schoolid));

      $permanentcoachid = null;
      $permanentcoach = $this->db->query('select userid from schoollink where schoolid = ?',array($schoolid));
      if($permanentcoach->num_rows() != null)
        $permanentcoachid = $permanentcoach->row(0)->userid;
      
      
      $this->load->view('coaches/view_masslink_coach',
         array('current' => 'coaches',
               'permanentcoachid' => $permanentcoachid,
               'coachid' => $coachid,
               'schoolid' => $schoolid,
               'schoolname' => $school->row(0)->schoolname,
               'coachname' => $coach->row(0)->firstname . ' ' . $coach->row(0)->surname
      ));
      
   }

   public function link()
   {
      $coachid = decuri($this->uri->segment(3));
      $schoolid = decuri($this->uri->segment(4));
      
      if($this->input->post('formpost'))
      {
         if($this->input->post('massselected_school') != '')
         {
            $selected_schools = $this->input->post('massselected_school');
            var_dump($selected_schools);
         }
       //   else{
       //   $coachid = $this->input->post('coachid');
       //   $schoolid = $this->input->post('schoolid');
         
       //   if($this->input->post('sessionlink') == '1')
       //   {
       //      if($this->input->post('sessionid') == '')
       //         error_msg('Please select the session to link to.');
       //      else
       //      {
       //         $this->db->query('update session set coachid = ? where sessionid = ?',array($coachid,$this->input->post('sessionid')));
       //         success_msg('Coach linked!');
       //         header('Location: /coaches');
       //         exit;
       //      }
       //   }
       //   else
       //   {
       //      $this->db->query('delete from schoollink where schoolid = ? and userid = ?',
       //         array($this->input->post('schoolid'),
       //               $this->input->post('coachid')         
       //      ));
       //      $this->db->query('insert schoollink (schoolid, userid) values(?,?)',
       //         array($this->input->post('schoolid'),
       //               $this->input->post('coachid')
       //      ));
       //      success_msg('Coach linked!');
       //      header('Location: /coaches');
       //      exit;            
       //   }
       // }
      }
      
      // $coach = $this->db->query('select firstname, surname from user where userid = ?',array($coachid));
      // $school = $this->db->query('select schoolname from school where schoolid = ?',array($schoolid));

      // $permanentcoachid = null;
      // $permanentcoach = $this->db->query('select userid from schoollink where schoolid = ?',array($schoolid));
      // if($permanentcoach->num_rows() != null)
      //   $permanentcoachid = $permanentcoach->row(0)->userid;
      
      
      // $this->load->view('coaches/view_link_coach',
      //    array('current' => 'coaches',
      //          'permanentcoachid' => $permanentcoachid,
      //          'coachid' => $coachid,
      //          'schoolid' => $schoolid,
      //          'schoolname' => $school->row(0)->schoolname,
      //          'coachname' => $coach->row(0)->firstname . ' ' . $coach->row(0)->surname
      // ));
      
   }
   
   public function viewlinks()
   {
       $coachid = decuri($this->uri->segment(3));  
       if($this->input->post('formpost')) {
           
           $schoollinks = $this->input->post('schoollink');
           if($schoollinks != null)
           {
               $count = 0;
               foreach($schoollinks as $schoollink)
               {
                   $this->db->query('delete from schoollink where schoollinkid = ?',array($schoollink));
                   $count++;
               }
               success_msg('Successfully unlinked ' . $count . ' schools.');
           }
       }       
       
       $coach = $this->db->query('select firstname, surname from user where userid = ?',array($coachid));
       
       $this->load->view('coaches/view_unlink_coach',array(
            'current' => 'coaches',
            'coachid' => $coachid,
            'coachname' => $coach->row(0)->firstname . ' ' . $coach->row(0)->surname
       )); 
   }

}

/* End of file coaches.php */
/* Location: ./application/controllers/coaches.php */