<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Evaluators extends My_Controller {

	public function index()
	{
      $evaluators = $this->db->query('select * from user where usertypeid = 4 and deleted is null order by surname, firstname');
      $this->load->view('evaluators/view_evaluators',
         array('current' => 'evaluators',
               'evaluators' => $evaluators      
      ));
	}
   
   public function edit()
   {
      if($this->uri->segment(3) == '')
         $evaluatorid = '';
      else
         $evaluatorid = decuri($this->uri->segment(3));
         
      if($this->input->post('formpost'))
      {
         $evaluatorid = $this->input->post('evaluatorid');
         if($evaluatorid == '')
         {
            $rs = $this->db->query('select * from user where username = ?',array($this->input->post('username')));
            if($rs->num_rows() != 0)
               error_msg('Another user with the same username already exists.');
            else
            {        
               if($this->input->post('password') != $this->input->post('confirmpassword'))
                  error_msg('Your passwords do not match!');    
               else
               {
                  $this->db->query('insert into user (usertypeid, username, password, firstname, surname, tel, cell, email, 
                                    idnumber, relativename, relativetel, relativecell, relativeemail, physicaladdress1, physicaladdress2,
                                    physicalsuburb, physicalcity, physicalprovince, physicalcode, postaladdress1, postaladdress2,
                                    postalsuburb, postalprovince, postalcity, postalcode, medicalaidname, medicalaidscheme, medicalaidnumber,
                                    bankname, branchname, branchnumber, accountname, accountnumber, createdon, createdbyuserid) 
                                    values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP,?)',
                                    array($this->input->post('usertype'),                           
                                       $this->input->post('username'),
                                       $this->input->post('password'),
                                       $this->input->post('firstname'),
                                       $this->input->post('surname'),
                                       $this->input->post('tel'),
                                       $this->input->post('cell'),
                                       $this->input->post('email'),
                                       $this->input->post('idnumber'),
                                       $this->input->post('relativename'),
                                       $this->input->post('relativetel'),
                                       $this->input->post('relativecell'),
                                       $this->input->post('relativeemail'),
                                       $this->input->post('physicaladdress1'),
                                       $this->input->post('physicaladdress2'),
                                       $this->input->post('physicalsuburb'),
                                       $this->input->post('physicalcity'),
                                       $this->input->post('physicalprovince'),
                                       $this->input->post('physicalcode'),
                                       $this->input->post('postaladdress1'),
                                       $this->input->post('postaladdress2'),
                                       $this->input->post('postalsuburb'),
                                       $this->input->post('postalprovince'),
                                       $this->input->post('postalcity'),
                                       $this->input->post('postalcode'),
                                       $this->input->post('medicalaidname'),
                                       $this->input->post('medicalaidscheme'),
                                       $this->input->post('medicalaidnumber'),
                                       $this->input->post('bankname'),
                                       $this->input->post('branchname'),
                                       $this->input->post('branchnumber'),
                                       $this->input->post('accountname'),
                                       $this->input->post('accountnumber'),
                                       user()->userid                          
                  ));
                  success_msg('Evaluator added successfully!');         
                  header('Location: /evaluators');
                  exit;
               }
            }
         }
         else
         {
            if($this->input->post('password') != $this->input->post('confirmpassword'))
               error_msg('Your passwords do not match!');
            else
            {
               $this->db->query('update user set
                              usertypeid = ?,
                              username = ?,
                              password = ?,
                              firstname = ?,
                              surname = ?,
                              tel = ?,
                              cell = ?,
                              email = ?,
                              idnumber = ?,
                              relativename = ?,
                              relativetel = ?,
                              relativecell = ?,
                              relativeemail = ?,
                              physicaladdress1 = ?,
                              physicaladdress2 = ?,
                              physicalsuburb = ?,
                              physicalcity = ?,
                              physicalprovince = ?,
                              physicalcode = ?,
                              postaladdress1 = ?,
                              postaladdress2 = ?,
                              postalsuburb = ?,
                              postalprovince = ?,
                              postalcity = ?,
                              postalcode = ?,
                              medicalaidname = ?,
                              medicalaidscheme = ?,
                              medicalaidnumber = ?,
                              bankname = ?,
                              branchname = ?,
                              branchnumber = ?,
                              accountname = ?,
                              accountnumber = ?,
                              updatedon = CURRENT_TIMESTAMP,
                              updatedbyuserid = ?
                              where userid = ?',
                              array($this->input->post('usertype'),                           
                                    $this->input->post('username'),
                                    $this->input->post('password'),
                                    $this->input->post('firstname'),
                                    $this->input->post('surname'),
                                    $this->input->post('tel'),
                                    $this->input->post('cell'),
                                    $this->input->post('email'),
                                    $this->input->post('idnumber'),
                                    $this->input->post('relativename'),
                                    $this->input->post('relativetel'),
                                    $this->input->post('relativecell'),
                                    $this->input->post('relativeemail'),
                                    $this->input->post('physicaladdress1'),
                                    $this->input->post('physicaladdress2'),
                                    $this->input->post('physicalsuburb'),
                                    $this->input->post('physicalcity'),
                                    $this->input->post('physicalprovince'),
                                    $this->input->post('physicalcode'),
                                    $this->input->post('postaladdress1'),
                                    $this->input->post('postaladdress2'),
                                    $this->input->post('postalsuburb'),
                                    $this->input->post('postalprovince'),
                                    $this->input->post('postalcity'),
                                    $this->input->post('postalcode'),
                                    $this->input->post('medicalaidname'),
                                    $this->input->post('medicalaidscheme'),
                                    $this->input->post('medicalaidnumber'),
                                    $this->input->post('bankname'),
                                    $this->input->post('branchname'),
                                    $this->input->post('branchnumber'),
                                    $this->input->post('accountname'),
                                    $this->input->post('accountnumber'),
                                    user()->userid,
                                    $evaluatorid                           
               ));         
            
               success_msg('Evaluator updated successfully!');       
               header('Location: /evaluators');
               exit;  
            }
         }
      }
      
      $user = null;
      
      if($evaluatorid != '')
      {
         $user = $this->db->query('select * from user where userid = ?',array($evaluatorid));
         $pagetitle = 'Edit Evaluator';
      }
      else
         $pagetitle = 'New Evaluator';
      
      $this->load->view('evaluators/view_edit_evaluator',
         array('current' => 'evaluators',
               'pagetitle' => $pagetitle,
               'user' => $user,
               'evaluatorid' => $evaluatorid
      ));
      
   }
   
   public function delete()
   {
      $evaluatorid = decuri($this->uri->segment(3));
      $this->db->query('delete from user where userid = ?',array($evaluatorid));
      success_msg('Evaluator deleted!');
      header('Location: /evaluators');
   }
   
   public function link()
   {
      $evaluatorid = decuri($this->uri->segment(3));
      $schoolid = decuri($this->uri->segment(4));
      
      if($this->input->post('formpost'))
      {
         $evaluatorid = $this->input->post('evaluatorid');
         $schoolid = $this->input->post('schoolid');
         
         if($this->input->post('sessionlink') == '1')
         {
            if($this->input->post('sessionid') == '')
               error_msg('Please select the session to link to.');
            else
            {
               $this->db->query('update session set evaluatorid = ? where sessionid = ?',array($evaluatorid,$this->input->post('sessionid')));
               success_msg('Evaluator linked!');
               header('Location: /evaluators');
               exit;
            }
         }
         else
         {
            $this->db->query('delete from schoollink where schoolid = ? and userid = ?',
               array($this->input->post('schoolid'),
                     $this->input->post('evaluatorid')         
            ));
            $this->db->query('insert schoollink (schoolid, userid) values(?,?)',
               array($this->input->post('schoolid'),
                     $this->input->post('evaluatorid')
            ));
            success_msg('Evaluator linked!');
            header('Location: /evaluators');
            exit;            
         }
      }
      
      $evaluator = $this->db->query('select firstname, surname from user where userid = ?',array($evaluatorid));
      $school = $this->db->query('select schoolname from school where schoolid = ?',array($schoolid));

      
      $this->load->view('evaluators/view_link_evaluators',
         array('current' => 'evaluators',
               'evaluatorid' => $evaluatorid,
               'schoolid' => $schoolid,
               'schoolname' => $school->row(0)->schoolname,
               'evaluatorname' => $evaluator->row(0)->firstname . ' ' . $evaluator->row(0)->surname
      ));
      
   }

}

/* End of file evaluator.php */
/* Location: ./application/controllers/evaluator.php */