<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Reports extends My_Controller {

	public function index()
	{	
      $students = null;
      if($this->input->post('formpost'))
      {
         if($this->input->post('report') == 'evalstats')
         {
            if($this->input->post('studentdetail') == 'By Student')
            {
                 header('Location: /students/select/' . encuri('/reports/evalstats/student'));
                 exit;
            } 
            else if(user()->usertypeid >= 3)  
            {
                $rs = $this->db->query('select date(s.sessiondate) as sessiondate,avg(e.value) as value,l.value as item from evaluation e
                                        inner join lookup l on l.lookupid = e.evaluationitemid
                                        inner join session s on s.sessionid = e.sessionid
                                        where s.evaluatorid = ?
                                        group by date(s.sessiondate),l.value
                                        order by date(s.sessiondate),l.value',array(
                    user()->userid
                ));
            }
            else
            {
                $rs = $this->db->query('select date(s.sessiondate) as sessiondate,avg(e.value) as value,l.value as item from evaluation e
                                        inner join lookup l on l.lookupid = e.evaluationitemid
                                        inner join session s on s.sessionid = e.sessionid
                                        where s.schoolid = ?
                                        group by date(s.sessiondate),l.value
                                        order by date(s.sessiondate),l.value',array(
                    $this->input->post('schoolid')
                ));                
            }
            
            $dates = array();
            foreach($rs->result() as $row)
            {
                if(!in_array($row->sessiondate,$dates))
                    $dates[] = $row->sessiondate;
            }
            
            $categories = array();
            foreach($rs->result() as $row)
            {
                if(!in_array($row->item,$categories))
                    $categories[] = $row->item;
            }
             
            $this->load->view('reports/view_chart_report',
                array('reporttitle' => 'Evaluation Statistics',
                      'current' => 'reports',
                      'rs' => $rs,
                      'dates' => $dates,
                      'categories' => $categories
            ));
            return;
         }          
         else if($this->input->post('report') == 'attendance')
         {
            $sessionid = $this->input->post('sessionid');
            $session = $this->db->query('select * from session where sessionid = ?',array($sessionid));
            $school = $this->db->query('select * from school where schoolid = ?',array($session->row(0)->schoolid));
            $coach = $this->db->query('select * from user where userid = ?',array($session->row(0)->coachid));      
            $students = $this->db->query('select s.*,ss.attending,ss.paid,ss.paidamount 
                                    from student s 
                                    left join studentsession ss on ss.studentid = s.studentid and ss.sessionid = ? 
                                    where s.schoolid = ? and not s.approvedon is null and s.deleted is null',array($sessionid,$school->row(0)->schoolid));
            
            $output = $this->load->view('templates/report_attendance',array(
               'session' => $session,
               'school' => $school,
               'coach' => $coach,
               'students' => $students
            ),true);
            //echo $output;
            //exit;         
            
            pdf_create($output,'Attendance Register.pdf',true);
            
         }
         else if($this->input->post('report') == 'studentdetail')   
         {
            if($this->input->post('studentdetail') == 'By School')
               header('Location: /reports/studentdetail/' . encuri($this->input->post('schoolid')));               
            else
               header('Location: /students/select/' . encuri('/reports/studentdetail/student'));
            exit;                                              
         }
         else if($this->input->post('report') == 'session')
         {
            $sessions = $this->db->query('select sc.schoolname,c.firstname,c.surname,s.sessiondate,s.starttime,s.endtime 
                                          from session s
                                          inner join school sc on sc.schoolid = s.schoolid
                                          inner join user c on c.userid = s.coachid
                                          where s.sessiondate >= ? and s.sessiondate <= ?',
                                          array($this->input->post('fromdate'),
                                                $this->input->post('todate')
            ));            
            
            $reportoutput = $this->load->view('templates/report_sessionreport',array(
               'sessions' => $sessions
            ),true);
            
            $this->load->view('reports/view_display_report',array(
               'current' => 'Reports',
               'reporttitle' => 'Session Report',
               'reportoutput' => $reportoutput
            ));              
            return;
         }
         else if($this->input->post('report') == 'generic')
         {
            if($this->input->post('generic') == 'Unsubmitted Sessions')
            {
               $schools = $this->db->query('select sc.schoolname,c.firstname,c.surname,s.sessiondate,s.starttime from session s 
                                            inner join school sc on sc.schoolid = s.schoolid 
                                            inner join user c on c.userid = s.coachid 
                                            where s.sessionendedon is null and not s.sessionstartedon is null');         
                     
               $reportoutput = $this->load->view('templates/report_ubsubmittedsessions',array(
                  'schools' => $schools
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'Ubsubmitted Sessions',
                  'reportoutput' => $reportoutput
               ));              
               return;                 
                         
            }
            else if($this->input->post('generic') == 'Coach Report')
            {
               if($this->input->post('coachid') != '')
                  $coach = $this->db->query('select * from user where usertypeid = 3 and userid = ? and deleted is null order by firstname,surname',array($this->input->post('coachid')));
               else
                  $coach = $this->db->query('select * from user where usertypeid = 3 and deleted is null order by firstname,surname');

               $reportoutput = $this->load->view('templates/report_coachreport',array(
                  'coach' => $coach
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'Coach Report',
                  'reportoutput' => $reportoutput
               ));              
               return;                 
            }
            else if($this->input->post('generic') == 'Amount of Students')
            {
               $schools = $this->db->query('select count(*) as total,sc.schoolname from student s 
                                             inner join school sc on s.schoolid = sc.schoolid where not s.approvedon is null
                                             group by sc.schoolname order by sc.schoolname');

               $provinces = $this->db->query('select count(*) as total,sc.physicalprovince from student s 
                                             inner join school sc on s.schoolid = sc.schoolid  where not s.approvedon is null
                                             group by sc.physicalprovince order by sc.physicalprovince');                                             
               
               $reportoutput = $this->load->view('templates/report_amountofstudents',array(
                  'schools' => $schools,
                  'provinces' => $provinces
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'Amount of Students',
                  'reportoutput' => $reportoutput
               ));              
               return;                   
            }            
            else if($this->input->post('generic') == 'T-Shirt Ordering')
            {
               $order = $this->db->query('select s.schoolname,l.value as size,count(*) as total from student st
                                            inner join school s on st.schoolid = s.schoolid
                                            inner join lookup l on l.lookupid = st.tshirtsizeid
                                            group by s.schoolname,l.value
                                            order by s.schoolname, l.value');         
                                                                       
               $reportoutput = $this->load->view('templates/report_tshirtordering',array(
                  'order' => $order
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'T-Shirt Ordering Report',
                  'reportoutput' => $reportoutput
               ));              
               return;               
                          
            }        
            else if($this->input->post('generic') == 'Merchandise Not Received')
            {
               $order = $this->db->query('select s.schoolname,c.firstname as coachfirst,c.surname as coachlast,st.firstname as studentfirst,st.surname as studentlast
                                          from item i
                                          inner join lookup l on l.lookupid = i.issueitemid
                                          inner join student st on st.studentid = i.studentid
                                          inner join school s on s.schoolid = st.schoolid
                                          left join schoollink sl on sl.schoolid = s.schoolid
                                          inner join user c on c.userid = sl.userid
                                          where l.lookupid = 12 and i.receivedsessionid is null');         

               $reportoutput = $this->load->view('templates/report_merchandisenotreceived',array(
                  'order' => $order
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'Merchandise Not Received',
                  'reportoutput' => $reportoutput
               ));              
               return;                  
                           
            }                 
            exit;
         }
         else if($this->input->post('report') == 'certificate')
         {
            $students = $this->input->post('students');
            if($students == null)
            {
               $students = $this->db->query('select * from student where schoolid = ? order by firstname,surname',array($this->input->post('schoolid')));               
            }
            else
            {
               $list = '';
               foreach($students as $studentid)
               {
                  if($list != '')
                     $list .= ',';
                  $list .= $studentid;
               }
               $students = $this->db->query('select * from student where studentid in (' . $list . ')');
               
               $output = $this->load->view('templates/report_certificate',
                  array('students' => $students
               ),true);
               
               pdf_create($output,'certificates.pdf',true);               
               exit;
            }
         }
         else if($this->input->post('report') == 'sibling')
         {
            $siblings = $this->db->query('select s0.studentnumber,s0.firstname,s0.surname,sc0.schoolname,
                                        s1.studentnumber as studentnumber1,s1.firstname as firstname1,sc1.schoolname as schoolname1,
                                        s2.studentnumber as studentnumbe2,s2.firstname as firstname2,sc2.schoolname as schoolname2,
                                        s3.studentnumber as studentnumbe3,s3.firstname as firstname3,sc3.schoolname as schoolname3,
                                        s4.studentnumber as studentnumbe4,s4.firstname as firstname4,sc4.schoolname as schoolname4,
                                        s5.studentnumber as studentnumber5,s5.firstname as firstname5,sc5.schoolname as schoolname5
                                        from student s0 
                                        inner join school sc0 on sc0.schoolid = s0.schoolid
                                        left join student s1 on s1.studentid = s0.sibling1id
                                        left join school sc1 on sc1.schoolid = s1.schoolid
                                        left join student s2 on s2.studentid = s0.sibling2id
                                        left join school sc2 on sc2.schoolid = s2.schoolid
                                        left join student s3 on s3.studentid = s0.sibling3id
                                        left join school sc3 on sc3.schoolid = s3.schoolid
                                        left join student s4 on s4.studentid = s0.sibling4id
                                        left join school sc4 on sc4.schoolid = s4.schoolid
                                        left join student s5 on s5.studentid = s0.sibling5id
                                        left join school sc5 on sc5.schoolid = s5.schoolid
                                        where 
                                        (not s0.sibling1id is null or s0.sibling1id <> 0)
                                        or
                                        (not s0.sibling2id is null or s0.sibling2id <> 0)
                                        or
                                        (not s0.sibling3id is null or s0.sibling3id <> 0)
                                        or
                                        (not s0.sibling4id is null or s0.sibling4id <> 0)
                                        or
                                        (not s0.sibling5id is null or s0.sibling5id <> 0)
                                        order by s0.studentid');
               
               $reportoutput = $this->load->view('templates/report_siblings',array(
                  'siblings' => $siblings
               ),true);
               
               $this->load->view('reports/view_display_report',array(
                  'current' => 'Reports',
                  'reporttitle' => 'Merchandise Not Received',
                  'reportoutput' => $reportoutput
               ));              
               return;                                       
         }
         else if($this->input->post('report') == 'emailaddress')
         {
            header("Content-type: text/csv");
            header("Cache-Control: no-store, no-cache");
            header('Content-Disposition: attachment; filename="filename.csv"'); 
             
            echo "\"Province\",\"School\",\"Email\"\r\n";
            $rs = $this->db->query('select sc.physicalprovince,sc.schoolname,s.parentemail 
                                    from student s 
                                    inner join school sc on sc.schoolid = s.schoolid
                                    order by sc.physicalprovince,sc.schoolname,s.parentemail');             
            foreach($rs->result() as $row)
            {
                echo "\"" . $row->physicalprovince . "\",";
                echo "\"" . $row->schoolname . "\",";
                echo "\"" . $row->parentemail . "\"\r\n";
            }
            exit;
         }
         else if($this->input->post('report') == 'smsnumber')
         {
            header("Content-type: text/csv");
            header("Cache-Control: no-store, no-cache");
            header('Content-Disposition: attachment; filename="filename.csv"'); 
             
            echo "\"Student and Cell\"\r\n";
            $rs = $this->db->query('select s.studentnumber,s.parentcell from student s inner join school sc on sc.schoolid = s.schoolid');             
            foreach($rs->result() as $row)
            {
                echo "\"" . $row->studentnumber . "," . $row->parentcell . "\"\r\n";
            } 
            exit;
         }
         else if($this->input->post('report') == 'stickers')
         {
             if($this->input->post('schoolid') != '')
             {
                $rs = $this->db->query('select sc.schoolname,s.studentnumber,s.firstname,s.surname,t.value as tshirt
                                     from student s 
                                     inner join school sc on sc.schoolid = s.schoolid
                                     inner join lookup t on t.lookupid = s.tshirtsizeid
                                     where s.schoolid = ? order by sc.schoolname, s.firstname, s.surname
                                     ',array($this->input->post('schoolid')));                 
                $output = $this->load->view('templates/report_stickers',array('rs' => $rs),true);             
                
                //echo $output;
               // exit;
                
                 pdf_create($output,'Stickers.pdf',true);
                 exit;
             }
             else
                error_msg('Select the school to generate stickers for.');                          
         }
         else if($this->input->post('report') == 'studentexport')
         {
            header("Content-type: text/csv");
            header("Cache-Control: no-store, no-cache");
            header('Content-Disposition: attachment; filename="filename.csv"'); 
            
            $where = ' not s.approvedon is null ';
            if($this->input->post('exportoption') == '1')
            {
            	if($where != '')
            	    $where .= ' and ';
                $where .= ' not s.approvedon is null';                

                if($this->input->post('schoolid') != '')
                {
	            if($where != '')
	            	$where .= ' and ';                
                    $where .= ' s.schoolid = ' . $this->input->post('schoolid');                
                }
            }
            else 
            {
                if($this->input->post('schoolid') != '')
                {
            	    if($where != '')
            		$where .= ' and ';                
                    $where = ' s.schoolid = ' . $this->input->post('schoolid');
                }
            }
            
            $sql = 'select sc.schoolname,s.*,ts.value as tshirt,pm.value as paymentmethod,
                                    s1.firstname as s1first,s1.birthdate as s1birth,
                                    s2.firstname as s2first,s2.birthdate as s2birth,
                                    s3.firstname as s3first,s3.birthdate as s3birth,
                                    s4.firstname as s4first,s4.birthdate as s4birth,
                                    s5.firstname as s5first,s5.birthdate as s5birth
                                    from student s 
                                    inner join school sc on sc.schoolid = s.schoolid
                                    left join lookup ts on ts.lookupid = s.tshirtsizeid
                                    left join lookup pm on pm.lookupid = s.paymentmethodid
                                    left join student s1 on s1.studentid = s.sibling1id
                                    left join student s2 on s2.studentid = s.sibling2id
                                    left join student s3 on s3.studentid = s.sibling3id
                                    left join student s4 on s4.studentid = s.sibling4id
                                    left join student s5 on s5.studentid = s.sibling5id';       
            if($where != '')
                $sql .= ' where ' . $where;                
            
            $sql .= ' order by sc.schoolname,s.surname,s.firstname';

            $rs = $this->db->query($sql);              
            
            echo "\"School Name\",";
            echo "\"Student Number\",";
            echo "\"First Name\",";
            echo "\"Surname\","; 
            echo "\"Birth Date\",";
            echo "\"T-Shirt\","; 
            echo "\"Parent Name\","; 
            echo "\"Parent Email\","; 
            echo "\"Parent Cell\","; 
            echo "\"Parent 2 Name\","; 
            echo "\"Parent 2 Email\","; 
            echo "\"Parent 2 Cell\","; 
            echo "\"Payment Method\","; 
            echo "\"Sibling 1\",";                                 
            echo "\"Sibling 1 Birth\",";
            echo "\"Sibling 2\",";                                 
            echo "\"Sibling 2 Birth\",";
            echo "\"Sibling 3\",";                                
            echo "\"Sibling 3 Birth\",";
            echo "\"Sibling 4\",";                                 
            echo "\"Sibling 4 Birth\",";
            echo "\"Sibling 5\",";                                 
            echo "\"Sibling 5 Birth\"\r\n";
            
            foreach($rs->result() as $row)
            {
                echo "\"" . $row->schoolname . "\",";
                echo "\"" . $row->studentnumber . "\",";
                echo "\"" . $row->firstname . "\",";
                echo "\"" . $row->surname . "\","; 
                echo "\"" . date('Y-m-d',strtotime($row->birthdate)) . "\",";
                echo "\"" . $row->tshirt . "\","; 
                echo "\"" . $row->parentname . "\","; 
                echo "\"" . $row->parentemail . "\","; 
                echo "\"" . $row->parentcell . "\","; 
                echo "\"" . $row->parent2name . "\","; 
                echo "\"" . $row->parent2email . "\","; 
                echo "\"" . $row->parent2cell . "\","; 
                echo "\"" . $row->paymentmethod . "\","; 
                echo "\"" . $row->s1first . "\",";                                 
                echo "\"" . date('Y-m-d',strtotime($row->s1birth)) . "\",";
                echo "\"" . $row->s2first . "\",";                                 
                echo "\"" . date('Y-m-d',strtotime($row->s2birth)) . "\",";
                echo "\"" . $row->s3first . "\",";                                
                echo "\"" . date('Y-m-d',strtotime($row->s3birth)) . "\",";
                echo "\"" . $row->s4first . "\",";                                 
                echo "\"" . date('Y-m-d',strtotime($row->s4birth)) . "\",";
                echo "\"" . $row->s5first . "\",";                                 
                echo "\"" . date('Y-m-d',strtotime($row->s5birth)) . "\"\r\n";
                
                $this->db->query('update student set exported = current_timestamp where studentid = ?',array($row->studentid));
            } 
            exit;
         }
      }
      
      $this->load->view('reports/view_reports',
         array('current' => 'reports',
               'students' => $students
      ));
	}
   
   public function studentdetail()
   {
      $school = null;
      $students = null;
      if($this->uri->segment(3) == 'student')
      {
         $studentid = decuri($this->uri->segment(4));  
         $school = $this->db->query('select sc.* from student s inner join school sc on sc.schoolid = s.schoolid where s.studentid = ?',array($studentid));
         $students = $this->db->query('select s.*,l.value as tshirtsize from student s
                                       inner join lookup l on l.lookupid = s.tshirtsizeid
                                       where studentid = ?',array(
            $studentid
         ));
      }
      else
      {
         $schoolid = decuri($this->uri->segment(3));
         $studentid = null;
         $school = $this->db->query('select * from school where schoolid = ?',array($schoolid));
         $students = $this->db->query('select s.*,l.value as tshirtsize from student s
                                       inner join lookup l on l.lookupid = s.tshirtsizeid
                                       where schoolid = ?',array(
            $schoolid
         ));
      }      
      
      $reportoutput = $this->load->view('templates/report_studentdetail',array(
         'school' => $school,
         'students' => $students
      ),true);
      
      $this->load->view('reports/view_display_report',array(
         'current' => 'Reports',
         'reporttitle' => 'Student / School Detail Report',
         'reportoutput' => $reportoutput
      ));              
      return;        
   }
   
   public function evalstats()
   {
      $school = null;
      $students = null;
      if($this->uri->segment(3) == 'student')
      {
          $studentid = decuri($this->uri->segment(4));  
          $rs = $this->db->query('select date(s.sessiondate) as sessiondate,avg(e.value) as value,l.value as item from evaluation e
                                        inner join lookup l on l.lookupid = e.evaluationitemid
                                        inner join session s on s.sessionid = e.sessionid
                                        inner join studentsession ss on ss.sessionid = s.sessionid                                        
                                        where ss.studentid = ?
                                        group by date(s.sessiondate),l.value
                                        order by date(s.sessiondate),l.value',array(
                    $studentid
          )); 
          
            $dates = array();
            foreach($rs->result() as $row)
            {
                if(!in_array($row->sessiondate,$dates))
                    $dates[] = $row->sessiondate;
            }
            
            $categories = array();
            foreach($rs->result() as $row)
            {
                if(!in_array($row->item,$categories))
                    $categories[] = $row->item;
            }
             
            $this->load->view('reports/view_chart_report',
                array('reporttitle' => 'Evaluation Statistics',
                      'current' => 'reports',
                      'rs' => $rs,
                      'dates' => $dates,
                      'categories' => $categories
            ));
      }
      
   }
}

/* End of file reports.php */
/* Location: ./application/controllers/mobile.php */