<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Schools extends My_Controller {

	public function index()
	{
      if(user()->usertypeid != '3')
         $schools = $this->db->query('select * from school where deleted is null order by schoolname');
      else
         $schools = $this->db->query('select s.* from school s inner join schoollink sl on sl.schoolid = s.schoolid where s.deleted is null and sl.userid = ? order by schoolname',
                     array(user()->userid
         ));
	   $this->load->view('schools/view_schools',
         array('current' => 'schools',
               'schools' => $schools      
      ));
	}
   
   public function edit()
   {
      if($this->uri->segment(3) == '')
         $schoolid = '';
      else
         $schoolid = decuri($this->uri->segment(3));
         
      if($this->input->post('formpost'))
      {
         $schoolid = $this->input->post('schoolid');
         if($schoolid == '')
         {
           
            $this->db->query('insert into school (schoolname, codename, studentnumbercode, tel, email, physicaladdress1, physicaladdress2,
                              physicalsuburb, physicalcity, physicalprovince, physicalcode, createdon, createdbyuserid, approvedon, approvedbyuserid)
                              values(?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP,?,CURRENT_TIMESTAMP,?)',
                              array($this->input->post('schoolname'),                           
                                 $this->input->post('codename'),
                                 $this->input->post('studentnumbercode'),
                                 $this->input->post('tel'),
                                 $this->input->post('email'),                                 
                                 $this->input->post('physicaladdress1'),
                                 $this->input->post('physicaladdress2'),
                                 $this->input->post('physicalsuburb'),
                                 $this->input->post('physicalcity'),
                                 $this->input->post('physicalprovince'),
                                 $this->input->post('physicalcode'),                              
                                 user()->userid,
                                 user()->userid                         
            ));
            success_msg('School added successfully!');         
            header('Location: /schools');
            exit;
         }
         else
         {           
            $this->db->query('update school set
                           schoolname = ?,
                           codename = ?,
                           studentnumbercode = ?,
                           tel = ?,
                           email = ?,            
                           physicaladdress1 = ?,
                           physicaladdress2 = ?,
                           physicalsuburb = ?,
                           physicalcity = ?,
                           physicalprovince = ?,
                           physicalcode = ?,            
                           updatedon = CURRENT_TIMESTAMP,
                           updatedbyuserid = ?
                           where schoolid = ?',
                           array($this->input->post('schoolname'),                           
                                 $this->input->post('codename'),
                                 $this->input->post('studentnumbercode'),
                                 $this->input->post('tel'),
                                 $this->input->post('email'),                                 
                                 $this->input->post('physicaladdress1'),
                                 $this->input->post('physicaladdress2'),
                                 $this->input->post('physicalsuburb'),
                                 $this->input->post('physicalcity'),
                                 $this->input->post('physicalprovince'),
                                 $this->input->post('physicalcode'),                           
                                 user()->userid,
                                 $schoolid                           
            ));         
         
            success_msg('School updated successfully!');       
            if($this->uri->segment(4) != '')
               header('Location: /sessions/details/' . $this->uri->segment(4));
            else
               header('Location: /schools');
            exit;  
         }
      }
      
      $school = null;
      
      if($schoolid != '')
      {
         $school = $this->db->query('select * from school where schoolid = ?',array($schoolid));
         $pagetitle = 'Edit School';
      }
      else
         $pagetitle = 'New School';
      
      $this->load->view('schools/view_edit_school',
         array('current' => 'schools',
               'pagetitle' => $pagetitle,
               'school' => $school,
               'schoolid' => $schoolid
      ));
      
   }   
   
   public function delete()
   {
      $schoolid = decuri($this->uri->segment(3));
      $this->db->query('delete from student where schoolid = ?',array($schoolid));
      $this->db->query('delete from school where schoolid = ?',array($schoolid));
      success_msg('School deleted!');
      header('Location: /schools');
   }    
   
   public function approve()
   {
      $schoolid = decuri($this->uri->segment(3));
      $this->db->query('update school set approvedon = CURRENT_TIMESTAMP, approvedbyuserid = ? where schoolid = ?',array(user()->userid,$schoolid));      
      success_msg('School approved!');
      header('Location: /schools');
   }    
   
   public function revoke()
   {
      $schoolid = decuri($this->uri->segment(3));
      $this->db->query('update school set approvedon = null, approvedbyuserid = null where schoolid = ?',array($schoolid));
      $this->db->query('update student set approvedon = null, approvedbyuserid = null where schoolid = ?',array($schoolid));
      success_msg('School approval revoked!');
      header('Location: /schools');
   }   
   
   public function select()
   {
     
          $nexturi = decuri($this->uri->segment(3));
      
      $schools = $this->db->query('select * from school where deleted is null order by schoolname');
      $this->load->view('schools/view_select_schools',
         array('current' => 'schools',               
               'schools' => $schools,
               'nexturi' => $nexturi     
      ));      
   } 

   public function massselect()
   {
        if($this->input->post('formpost'))
      {
         if($this->input->post('massselected_school') != '')
         {
            $coachid_dec = decuri($this->input->post('coachid'));
            $selected_schools = $this->input->post('massselected_school');
         foreach ($selected_schools as $key => $value){
            $this->db->query('delete from schoollink where schoolid = ? and userid = ?',
               array($value,
                     $coachid_dec      
            ));

            $this->db->query('insert schoollink (schoolid, userid) values(?,?)',
               array($value,
                     $coachid_dec
            ));
               
         }
               success_msg('Coach linked!');
               header('Location: /coaches');
               exit;
         }
      }
      else{

      //$coachid = decuri($this->uri->segment(5));
      $coachid = $this->uri->segment(3);
      $nexturi = '/coaches/masslink/';
      $schools = $this->db->query('select * from school where deleted is null order by schoolname');
      $this->load->view('schools/view_massselect_schools',
         array('current' => 'schools',               
               'schools' => $schools,
               'coachid' => $coachid,
               'nexturi' => $nexturi     
      ));     
      } 
   } 

}

/* End of file schools.php */
/* Location: ./application/controllers/schools.php */