<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sessions extends My_Controller {

	public function index()
	{
      header('Location: /dashboard');   
	}
   
   public function add()
   {
      $coachid = decuri($this->uri->segment(3));
      
      if($this->input->post('formpost'))
      {
         if(strlen($this->input->post('starttime')) != 5)
            error_msg('Invalid start time defined.');
         else if(strlen($this->input->post('endtime')) != 5)
            error_msg('Invalid end time defined.');         
         else 
         {
            if($this->input->post('repeat') == '2')         
               $repeatcount = 1;
            else
               $repeatcount = 60; // little more than 52 weeks, we'll check in the loop that we do not pass the end of the year
               
            
            $endofyear = date("Y-01-01");
            $endofyear = strtotime(date("Y-m-d", strtotime($endofyear)) . " +1 year");
               
            $sessiondate = $this->input->post('sessiondate');
            $groupsessionid = null;
            for($i=1;$i<=$repeatcount;$i++)
            {
               $this->db->query('insert into session (coachid, schoolid, sessiondate, starttime, endtime, createdon, createdbyuserid, groupsessionid) 
                                 values(?,?,?,?,?,CURRENT_TIMESTAMP,?,?)',
                                 array($coachid,
                                       $this->input->post('schoolid'),
                                       $sessiondate,
                                       $this->input->post('starttime'),
                                       $this->input->post('endtime'),
                                       user()->userid,
                                       $groupsessionid
               ));
               
               if($groupsessionid == null)
                  $groupsessionid = $this->db->insert_id();
               
               $sessiondate = date('Y-m-d',strtotime(date("Y-m-d", strtotime($sessiondate)) . " +1 week"));
               if(strtotime($sessiondate) > $endofyear)
                  break; // not more than next year
            }
            
            header('Location: /dashboard');
            exit;
            
         }
      }
      
      $coach = $this->db->query('select * from user where userid = ?',array($coachid));
      
      $this->load->view('sessions/view_sessions_add',
         array('current' => 'dashboard',
               'pagetitle' => 'Add New Coach Session',
               'coachid' => $coachid,
               'coach' => $coach         
      ));
   }
   
    public function addeval()
   {
      $coachid = decuri($this->uri->segment(3));
      
      if($this->input->post('formpost'))
      {
         if(strlen($this->input->post('starttime')) != 5)
            error_msg('Invalid start time defined.');
         else if(strlen($this->input->post('endtime')) != 5)
            error_msg('Invalid end time defined.');         
         else 
         {            
            $repeatcount = 1;            
            
            $endofyear = date("Y-01-01");
            $endofyear = strtotime(date("Y-m-d", strtotime($endofyear)) . " +1 year");
               
            $sessiondate = $this->input->post('sessiondate');
            $groupsessionid = null;
            for($i=1;$i<=$repeatcount;$i++)
            {
               $this->db->query('insert into session (evaluatorid, schoolid, sessiondate, starttime, endtime, createdon, createdbyuserid, groupsessionid) 
                                 values(?,?,?,?,?,CURRENT_TIMESTAMP,?,?)',
                                 array($coachid,
                                       $this->input->post('schoolid'),
                                       $sessiondate,
                                       $this->input->post('starttime'),
                                       $this->input->post('endtime'),
                                       user()->userid,
                                       $groupsessionid
               ));
                           
               $sessiondate = date('Y-m-d',strtotime(date("Y-m-d", strtotime($sessiondate)) . " +1 week"));
               if(strtotime($sessiondate) > $endofyear)
                  break; // not more than next year
            }
            
            header('Location: /dashboard');
            exit;
            
         }
      }
      
      $coach = $this->db->query('select * from user where userid = ?',array($coachid));
      
      $this->load->view('sessions/view_sessions_addeval',
         array('current' => 'dashboard',
               'pagetitle' => 'Add New Evaluation Session',
               'coachid' => $coachid,
               'coach' => $coach         
      ));
   }
   
   public function details()
   {
      $sessionid = decuri($this->uri->segment(3));
      
      if($this->input->post('formpost'))
      {
         set_time_limit(-1);
         $this->db->query('update session set sessionstartedon = CURRENT_TIMESTAMP where sessionstartedon is null and sessionid = ?',array($sessionid));
         
         if($this->input->post('typeofnote') != '')
         {
            if($this->input->post('typeofnote') == '1')   
               $this->db->query('update session set notes1 = ? where sessionid = ?',array($this->input->post('notes'),$sessionid));
            if($this->input->post('typeofnote') == '2')
            {   
               $this->db->query('update session set notes2 = ? where sessionid = ?',array($this->input->post('notes'),$sessionid));               
               $this->db->query('update studentsession set attending = null where sessionid = ?',array($sessionid));
            }
            if($this->input->post('typeofnote') == '3')
            {
               $this->db->query('update session set notes3 = ? where sessionid = ?',array($this->input->post('notes'),$sessionid));                              
               $admins = $this->db->query('select * from user where usertypeid = 2 and deleted is null');
               $coach = $this->db->query('select u.firstname,u.surname from user u inner join session s on s.coachid = u.userid where s.sessionid = ?',array($sessionid));
               foreach($admins->result() as $row)
               {  
                  $email = '<p>Dear ' . $row->firstname . ',</p>' .
                             '<p>Coach ' . $coach->row(0)->firstname . ' ' . $coach->row(0)->surname . ' has sent you the following urgent message: </p>' .
                             '<p>' . $this->input->post('notes') . '</p>';
                  comm_email($row->email,null,'Urgent Message',$email);
                  
                  $sms = $this->input->post('notes') . '. From: ' . $coach->row(0)->firstname . ' ' . $coach->row(0)->surname;
                  comm_sms($row->cell,$sms);
               }
            }
         }
         
         $student = $this->input->post('student');
         if($student != null)
         {            
            foreach($student as $studentid)
            {
               if(!student_session_exists($sessionid,$studentid))
                  $this->db->query('insert into studentsession (sessionid, studentid) values(?,?)',array($sessionid,$studentid));
            }
         }
         
         $attending = $this->input->post('attending');
         if($attending != null)
         {
            $this->db->query('update studentsession set attending = null where sessionid = ?',array($sessionid));
            
            foreach($attending as $studentid)
            {
               if(student_session_exists($sessionid,$studentid))
                  $this->db->query('update studentsession set attending = 1 where sessionid = ? and studentid = ?',array($sessionid,$studentid));
               else
                  $this->db->query('insert into studentsession (sessionid, studentid, attending) values(?,?,1)',array($sessionid,$studentid));
            }
         }
         
         /* Update Gifts Received */
         $rugby = $this->input->post('rugby');
         if($rugby != null)
         {            
            foreach($rugby as $studentid)
               $this->db->query('update item set receivedsessionid = ? where studentid = ? and issueitemid = 12 and receivedsessionid is null',array($sessionid,$studentid));
         }         
         $tshirt = $this->input->post('tshirt');
         if($tshirt != null)
         {            
            foreach($tshirt as $studentid)
               $this->db->query('update item set receivedsessionid = ? where studentid = ? and issueitemid = 13 and receivedsessionid is null',array($sessionid,$studentid));
         }         
         $waterbottle = $this->input->post('waterbottle'); 
         if($waterbottle != null)
         {            
            foreach($waterbottle as $studentid)
               $this->db->query('update item set receivedsessionid = ? where studentid = ? and issueitemid = 14 and receivedsessionid is null',array($sessionid,$studentid));
         }         
         $cert = $this->input->post('cert'); 
         if($cert != null)
         {            
            foreach($cert as $studentid)
               $this->db->query('update item set receivedsessionid = ? where studentid = ? and issueitemid = 15 and receivedsessionid is null',array($sessionid,$studentid));
         }     
         $medal = $this->input->post('medal'); 
         if($medal != null)
         {            
            foreach($medal as $studentid)
               $this->db->query('update item set receivedsessionid = ? where studentid = ? and issueitemid = 16 and receivedsessionid is null',array($sessionid,$studentid));
         }               
         
         $paid = $this->input->post('paid');
         if($paid != null)
         {
            $this->db->query('update studentsession set paid = null, paidamount = null where sessionid = ?',array($sessionid));
            
            foreach($paid as $studentid)
            {
               $amount = $this->input->post('paid_' . $studentid);
               if(student_session_exists($sessionid,$studentid))
                  $this->db->query('update studentsession set paid = 1, paidamount = ? where sessionid = ? and studentid = ?',array($amount,$sessionid,$studentid));
               else
                  $this->db->query('insert into studentsession (sessionid, studentid, paid, paidamount) values(?,?,1,?)',array($sessionid,$studentid,$amount));
            }
         }         
         
         if($this->input->post('submitaction') == 'submit')
         {
            $this->db->query('update session set sessionendedon = CURRENT_TIMESTAMP where sessionid = ?',array($sessionid));
            header('Location: /dashboard');
            exit;
         }      
      }
      
      $session = $this->db->query('select * from session where sessionid = ?',array($sessionid));
      $school = $this->db->query('select * from school where schoolid = ?',array($session->row(0)->schoolid));
      $coach = $this->db->query('select * from user where userid = ?',array($session->row(0)->coachid));      
      $students = $this->db->query('select s.*,ss.attending,ss.paid,ss.paidamount,ts.value as tshirtsize 
                                    from student s 
                                    left join studentsession ss on ss.studentid = s.studentid and ss.sessionid = ? 
                                    left join lookup ts on ts.lookupid = s.tshirtsizeid
                                    where s.schoolid = ? and not s.approvedon is null and s.deleted is null',array($sessionid,$school->row(0)->schoolid));
      $gifts = $this->db->query('select distinct issueitemid from item where studentid in(select studentid from student where schoolid = ?  and not approvedon is null) and receivedsessionid is null order by issueitemid',array($school->row(0)->schoolid));                                   
      
      $this->load->view('sessions/view_sessions_details',
         array('current' => 'dashboard',
               'pagetitle' => 'Capture Session Details',
               'sessionid' => $sessionid,
               'school' => $school,               
               'session' => $session,
               'coach' => $coach,
               'students' => $students,
               'gifts' => $gifts
      ));
      
   }
   
   public function edit()
   {
      $sessionid = decuri($this->uri->segment(3)); 
      
      if($this->input->post('formpost'))
      {
         $sessionid = $this->input->post('sessionid');
         $this->db->query('update session set coachid = ?,sessiondate=?,starttime=?,endtime=? where sessionid = ?',
            array($this->input->post('coachid'),
                  $this->input->post('sessiondate'),
                  $this->input->post('starttime'),
                  $this->input->post('endtime'),
                  $sessionid
         ));
         if($this->input->post('update') == '1')
         {            
            $schoolrs = $this->db->query('select schoolid,coachid,groupsessionid,sessiondate from session where sessionid = ?',array($this->input->post('sessionid')));
            $schoolid = $schoolrs->row(0)->schoolid;
            $coachid = $schoolrs->row(0)->coachid;
            
            // if it's a new coach, remove the link from the old one.
            if($coachid != $this->input->post('coachid'))
            {
               $this->db->query('delete from schoollink where coachid = ? and schoolid = ?',array($coachid,$schoolid));
            }
            
            $groupsessionid = $schoolrs->row(0)->groupsessionid;
            $firstsessiondate = null;
            if(($groupsessionid == null) || ($groupsessionid == ''))
            {
               $groupsessionid = $this->input->post('sessionid');
               $firstsessiondate = $schoolrs->row(0)->sessiondate;  
            }
               
            $sessiondate = $this->input->post('sessiondate');
               
            $this->db->query('delete from session where groupsessionid = ? and sessiondate >= ? and sessionid <> ?',array($groupsessionid,$sessiondate,$sessionid));
            
            $endofyear = date("Y-01-01");
            $endofyear = strtotime(date("Y-m-d", strtotime($endofyear)) . " +1 year");
            $sessiondate = date('Y-m-d',strtotime(date("Y-m-d", strtotime($sessiondate)) . " +1 week"));
            
            $repeatcount = 60;
            for($i=1;$i<=$repeatcount;$i++)
            {
               if(showdate($firstsessiondate) != showdate($sessiondate))
               {
                  $this->db->query('insert into session (coachid, schoolid, sessiondate, starttime, endtime, createdon, createdbyuserid, groupsessionid) 
                                    values(?,?,?,?,?,CURRENT_TIMESTAMP,?,?)',
                                    array($this->input->post('coachid'),
                                          $schoolid,
                                          $sessiondate,
                                          $this->input->post('starttime'),
                                          $this->input->post('endtime'),
                                          user()->userid,
                                          $groupsessionid
                  ));    
                  
                  
               }           
               
               $sessiondate = date('Y-m-d',strtotime(date("Y-m-d", strtotime($sessiondate)) . " +1 week"));
               if(strtotime($sessiondate) > $endofyear)
                  break; // not more than next year
            }
            
                        
                           
         }
      
         header('Location: /sessions/details/' . encuri($sessionid));
         exit;
      }

      $session = $this->db->query('select * from session where sessionid = ?',array($sessionid));
      $coach = $this->db->query('select * from user where userid = ?',array($session->row(0)->coachid));
      
      $this->load->view('sessions/view_sessions_edit',
         array('current' => 'dashboard',
               'pagetitle' => 'Edit Session',
               'sessionid' => $sessionid,               
               'session' => $session,
               'coach' => $coach
      ));      
   }
   
   public function delete()
   {
      $sessionid = decuri($this->uri->segment(3));      
      
      $grouprs = $this->db->query('select groupsessionid from session where sessionid = ?',array($sessionid));
      $groupsessionid = $grouprs->row(0)->groupsessionid;
      if(($groupsessionid == null) || ($groupsessionid == ''))
         $groupsessionid = $sessionid;
      
      $this->db->query('delete from session where sessionid = ? and sessionstartedon is null',array($sessionid));
      $this->db->query('delete from session where groupsessionid = ? and sessionstartedon is null',array($groupsessionid));
      $this->db->query('delete from session where sessionid = ? and sessionstartedon is null',array($groupsessionid));
      header('Location: /dashboard');
   }
   
   public function issue()
   {
      $sessionid = decuri($this->uri->segment(3));
      $studentid = decuri($this->uri->segment(4));      
      
      if($this->input->post('formpost'))
      {
         $items = $this->input->post('items');
         if($items != null)
         {
            foreach($items as $itemid)
            {
               $this->db->query('update item set receivedsessionid = ? where itemid = ?',array($sessionid,$itemid));
            }
         }  
         
         header('Location: /sessions/details/' . encuri($sessionid));
         exit;
      }      
      
      $student = $this->db->query('select * from student where studentid = ?',array($studentid));      
      $items = $this->db->query('select i.itemid,l.value,i.receivedsessionid from item i inner join lookup l on l.lookupid = i.issueitemid where i.studentid = ? and (i.receivedsessionid is null or i.receivedsessionid = ?)',array($studentid, $sessionid));      
      
      $this->load->view('sessions/view_sessions_issue',
         array('current' => 'dashboard',
               'pagetitle' => 'Issue Student Items',
               'sessionid' => $sessionid,               
               'studentid' => $studentid,
               'student' => $student,
               'items' => $items
      ));       
      
   }
   
   public function detailseval()
   {
      $sessionid = decuri($this->uri->segment(3));
      
      if($this->input->post('formpost'))
      {                  
         $student = $this->input->post('student');
         if($student != null)
         {            
            foreach($student as $studentid)
            {
                if(!student_session_exists($sessionid,$studentid))
                   $this->db->query('insert into studentsession (sessionid, studentid) values(?,?)',array($sessionid,$studentid));               
            }
         }
         
         $attending = $this->input->post('attending');
         if($attending != null)
         {
            $this->db->query('update studentsession set attending = null where sessionid = ?',array($sessionid));
            
            foreach($attending as $studentid)
            {
               if(student_session_exists($sessionid,$studentid))
                  $this->db->query('update studentsession set attending = 1 where sessionid = ? and studentid = ?',array($sessionid,$studentid));
               else
                  $this->db->query('insert into studentsession (sessionid, studentid, attending) values(?,?,1)',array($sessionid,$studentid));
            }
         } 
         
         $this->db->query('delete from evaluation where sessionid = ? and evaluationitemid = ?',array($sessionid,$this->input->post('evaluationitem')));
         $student = $this->input->post('student');
         foreach($student as $studentid)  
         {
            $eval = $this->input->post('eval_' . $studentid);
            $this->db->query('insert into evaluation (evaluationitemid,sessionid,studentid,value) values(?,?,?,?)',array(
                $this->input->post('evaluationitem'),
                $sessionid,
                $studentid,
                $eval
            ));
         }
                                              
      }
      
      $session = $this->db->query('select * from session where sessionid = ?',array($sessionid));
      $school = $this->db->query('select * from school where schoolid = ?',array($session->row(0)->schoolid));
      $coach = $this->db->query('select * from user where userid = ?',array($session->row(0)->coachid));      
      $students = $this->db->query('select s.*,ss.attending,ss.paid,ss.paidamount,ts.value as tshirtsize 
                                    from student s 
                                    left join studentsession ss on ss.studentid = s.studentid and ss.sessionid = ? 
                                    left join lookup ts on ts.lookupid = s.tshirtsizeid
                                    where s.schoolid = ? and not s.approvedon is null and s.deleted is null',array($sessionid,$school->row(0)->schoolid));
      
      $this->load->view('sessions/view_evalsessions_details',
         array('current' => 'dashboard',
               'pagetitle' => 'Capture Evaluation Details',
               'sessionid' => $sessionid,
               'school' => $school,               
               'session' => $session,
               'coach' => $coach,
               'students' => $students
      ));
      
   }
}

/* End of file sessions.php */
/* Location: ./application/controllers/sessions.php */