<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Students extends My_Controller {

	public function index()
	{
	}
   
   public function manage()
   {
      $schoolid = decuri($this->uri->segment(3));
      $students = $this->db->query('select s.studentid,s.firstname,s.surname,s.approvedon,s.studentnumber,sum(ss.paidamount) as totalpaid 
                                    from student s 
                                    left join studentsession ss on ss.studentid = s.studentid 
                                    where s.schoolid = ? and s.deleted is null 
                                    group by s.studentid,s.firstname,s.surname,s.approvedon,s.studentnumber
                                    order by s.firstname, s.surname',array($schoolid));
      $this->load->view('students/view_students',
         array('current' => 'schools',
               'students' => $students,
               'schoolid' => $schoolid      
      ));
   }
   
   public function add_siblings($index, $schoolid, $studentid)
   {
      if($this->input->post('firstname' . $index) != '')
      {
         $rs = $this->db->query('select studentid from student where studentnumber = ? ',array($this->input->post('studentnumber' . $index)));
         if($rs->num_rows() == 0)
         {
            $this->db->query('insert into student (schoolid, studentnumber, firstname, surname, birthdate, tshirtsizeid,
                              parentname, parentemail, parentcell, parent2name, parent2email, parent2cell, paymentmethodid, 
                              createdon, createdbyuserid,approvedon,approvedbyuserid)
                              values(?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP,?,CURRENT_TIMESTAMP,?)',
                              array($schoolid,                           
                                 $this->input->post('studentnumber' . $index),
                                 $this->input->post('firstname' . $index),
                                 $this->input->post('surname'),
                                 $this->input->post('birthdate' . $index),                                 
                                 $this->input->post('tshirtsizeid' . $index),
                                 $this->input->post('parentname'),
                                 $this->input->post('parentemail'),
                                 $this->input->post('parentcell'),
                                 $this->input->post('parent2name'),
                                 $this->input->post('parent2email'),
                                 $this->input->post('parent2cell'),                                 
                                 $this->input->post('paymentmethodid'),            
                                 user()->userid,
                                 user()->userid
            ));      
            $siblingid = $this->db->insert_id();       
         }
         else
            $siblingid = $rs->row(0)->studentid;
            
         $this->db->query('update student set sibling' . $index . 'id = ? where studentid = ?',array($siblingid,$studentid));
         $this->db->query('update student set sibling' . $index . 'id = ? where studentid = ?',array($studentid,$siblingid));
      }  
   }
   
   public function edit()
   {         
      if($this->uri->segment(3) == '')
         $schoolid = '';
      else
         $schoolid = decuri($this->uri->segment(3));
         
      if(($this->uri->segment(4) == '') || ($this->uri->segment(4) == 'new'))
         $studentid = '';
      else
         $studentid = decuri($this->uri->segment(4));               
               
      if($this->input->post('formpost'))
      {
         $studentid = $this->input->post('studentid');
         if($studentid == '')
         {
           
            $this->db->query('insert into student (schoolid, studentnumber, firstname, surname, birthdate, tshirtsizeid,
                              parentname, parentemail, parentcell, parent2name, parent2email, parent2cell, paymentmethodid, 
                              createdon, createdbyuserid,approvedon,approvedbyuserid)
                              values(?,?,?,?,?,?,?,?,?,?,?,?,?,CURRENT_TIMESTAMP,?,CURRENT_TIMESTAMP,?)',
                              array($schoolid,                           
                                 //$this->input->post('studentnumber'),
                                   $this->input->post('prefix').next_student_number($schoolid),
                                 $this->input->post('firstname'),
                                 $this->input->post('surname'),
                                 $this->input->post('birthdate'),                                 
                                 $this->input->post('tshirtsizeid'),
                                 $this->input->post('parentname'),
                                 $this->input->post('parentemail'),
                                 $this->input->post('parentcell'),
                                 $this->input->post('parent2name'),
                                 $this->input->post('parent2email'),
                                 $this->input->post('parent2cell'),                                 
                                 $this->input->post('paymentmethodid'),            
                                 user()->userid,
                                 user()->userid
            ));
                        
            $studentid = $this->db->insert_id();          

            $this->add_siblings(1,$schoolid,$studentid);
            $this->add_siblings(2,$schoolid,$studentid);
            $this->add_siblings(3,$schoolid,$studentid);
            
            send_welcome_notices($studentid);            
            
            if(user()->usertypeid == '3')
               add_notification($schoolid,$studentid,'New student added by coach.<br />');
                           
            success_msg('Student added successfully!'); 
            
            if($this->uri->segment(5) == 'session')        
               header('Location: /sessions/details/' . $this->uri->segment(6));
            else if($this->input->post('aftersaveaction') == 'return')
               header('Location: /students/edit/' . encuri($schoolid));
            else if($this->input->post('aftersaveaction') == 'continue')
               header('Location: /students/edit/' . encuri($schoolid) . '/' . encuri($studentid));               
            exit;
         }
         else
         {  
            $changeddetails = '';         
            $currentrs = $this->db->query('select * from student where studentid = ?',array($studentid));
            
            if($currentrs->row(0)->firstname != $this->input->post('firstname'))
               $changeddetails .= 'First name was changed.<br />';
            if($currentrs->row(0)->surname != $this->input->post('surname'))
               $changeddetails .= 'Surname was changed.<br />';               
            if(showdate($currentrs->row(0)->birthdate) != $this->input->post('birthdate'))
               $changeddetails .= 'Birth date was changed.<br />';                           
            if($currentrs->row(0)->tshirtsizeid != $this->input->post('tshirtsizeid'))
               $changeddetails .= 'T-shirt size was changed.<br />';                                          
            if($currentrs->row(0)->parentname != $this->input->post('parentname'))
               $changeddetails .= 'Parent name was changed.<br />';                                                         
            if($currentrs->row(0)->parentemail != $this->input->post('parentemail'))
               $changeddetails .= 'Parent email was changed.<br />';                                                                        
            if($currentrs->row(0)->parentcell != $this->input->post('parentcell'))
               $changeddetails .= 'Parent cell was changed.<br />';                                                                                       
            if($currentrs->row(0)->paymentmethodid != $this->input->post('paymentmethodid'))
               $changeddetails .= 'Payment method was changed.<br />';                                                                                                      
               
            if($changeddetails != '')
               add_notification($schoolid,$studentid,$changeddetails);                                                                                                                                 
            
            $this->db->query('update student set
                              studentnumber = ?, 
                              firstname = ?, 
                              surname = ?, 
                              birthdate = ?, 
                              tshirtsizeid = ?,
                              parentname = ?, 
                              parentemail = ?, 
                              parentcell = ?, 
                              parent2name = ?, 
                              parent2email = ?, 
                              parent2cell = ?,                               
                              paymentmethodid = ?, 
                              updatedon = CURRENT_TIMESTAMP, 
                              updatedbyuserid = ?
                              where studentid = ?',
                           array($this->input->post('studentnumber'),                           
                                 $this->input->post('firstname'),
                                 $this->input->post('surname'),
                                 $this->input->post('birthdate'),
                                 $this->input->post('tshirtsizeid'),                                 
                                 $this->input->post('parentname'),
                                 $this->input->post('parentemail'),
                                 $this->input->post('parentcell'),
                                 $this->input->post('parent2name'),
                                 $this->input->post('parent2email'),
                                 $this->input->post('parent2cell'),                                 
                                 $this->input->post('paymentmethodid'),            
                                 user()->userid,
                                 $studentid                           
            ));     
            
            $this->add_siblings(1,$schoolid,$studentid);
            $this->add_siblings(2,$schoolid,$studentid);
            $this->add_siblings(3,$schoolid,$studentid);
         
            success_msg('Student updated successfully!');       
            if($this->uri->segment(5) == 'session')        
               header('Location: /sessions/details/' . $this->uri->segment(6));
            else if($this->input->post('aftersaveaction') == 'return')
               header('Location: /students/manage/' . encuri($schoolid));
            else if($this->input->post('aftersaveaction') == 'continue')
               header('Location: /students/edit/' . encuri($schoolid) . '/' . encuri($studentid));
            exit;  
         }
      }
      
      $student = null;
      $sibling1 = null;
      $sibling2 = null;                      
      $sibling3 = null;                      
      
      if($studentid != '')
      {
         if(student_has_notification($studentid))
         {
            info_msg(get_student_notification($studentid));
            $this->db->query('update notification set closed = 1 where studentid = ?',array($studentid));
         }
         
         $student = $this->db->query('select s.* 
                                      from student s 
                                      where s.studentid = ?',
            array($studentid
         ));
         
         $sibling1 = $this->db->query('select * from student where sibling1id = ?',array($studentid));
         if($sibling1->num_rows() != 0)
         {
            $sibling2 = $this->db->query('select * from student where sibling1id = ? and studentid <> ?',array($studentid,$sibling1->row(0)->studentid));
            if($sibling2->num_rows() != 0)
            {
               $sibling3 = $this->db->query('select * from student where sibling1id = ? and studentid <> ? and studentid <> ?',array($studentid,$sibling1->row(0)->studentid,$sibling2->row(0)->studentid));
            }
         }         
         
         $pagetitle = 'Edit Student';
      }
      else
         $pagetitle = 'New Student';
      
      $this->load->view('students/view_edit_student',
         array('current' => 'schools',
               'pagetitle' => $pagetitle,
               'student' => $student,
               'schoolid' => $schoolid,
               'studentid' => $studentid,
               'sibling1' => $sibling1,
               'sibling2' => $sibling2,
               'sibling3' => $sibling3
      ));
      
   }   
   
   public function delete()
   {
      $schoolid = decuri($this->uri->segment(3));
      $studentid = decuri($this->uri->segment(4));
      $this->db->query('delete from student where studentid = ?',array($studentid));
      success_msg('Student deleted!');
      header('Location: /students/manage/' . encuri($schoolid));
   }    
   
   public function approve()
   {
      $schoolid = decuri($this->uri->segment(3));
      $studentid = decuri($this->uri->segment(4));
      $this->db->query('update student set approvedon = CURRENT_TIMESTAMP, approvedbyuserid = ? where studentid = ?',array(user()->userid,$studentid));
      
      //$this->db->query('delete from item where studentid = ? and receivedsessionid is null',array($studentid));      
      /*$issueitems = $this->db->query('select * from lookup where name = ?',array('Issue Item'));
      foreach($issueitems->result() as $issueitem)
      {
         $this->db->query('insert into item(issueitemid,studentid) values(?,?)',
                     array($issueitem->lookupid,
                           $studentid               
         ));
      } */     
      
      success_msg('Student approved!');
      header('Location: /students/manage/' . encuri($schoolid));
   }    
   
   public function revoke()
   {
      $schoolid = decuri($this->uri->segment(3));
      $studentid = decuri($this->uri->segment(4));
      $this->db->query('delete from item where studentid = ? and receivedsessionid is null',array($studentid));      
      $this->db->query('update student set approvedon = null, approvedbyuserid = null where studentid = ?',array($studentid));
      success_msg('Student approval revoked!');
      header('Location: /students/manage/' . encuri($schoolid));
   }    
   
   public function select()
   {      
      $nexturi = decuri($this->uri->segment(3));
      
      if(user()->usertypeid >= 3)
        $students = $this->db->query('select studentid,firstname,surname,birthdate,schoolname,student.approvedon 
                                      from student 
                                      inner join school on student.schoolid = school.schoolid 
                                      inner join schoollink on schoollink.schoolid = school.schoolid
                                      where student.deleted is null and schoollink.userid = ? order by schoolname,surname,firstname',array(user()->userid));
      else
        $students = $this->db->query('select studentid,firstname,surname,birthdate,schoolname,student.approvedon from student inner join school on student.schoolid = school.schoolid where student.deleted is null order by schoolname,surname,firstname');
      $this->load->view('students/view_select_students',
         array('current' => 'schools',
               'students' => $students,
               'nexturi' => $nexturi     
      ));         
   } 
   
   public function toggle_issue()
   {
      $studentid = decuri($this->uri->segment(3));
      $itemid = $this->uri->segment(4);
      $rs = $this->db->query('select itemid from item where issueitemid = ? and studentid = ? and receivedsessionid is null',array(         
         $itemid,
         $studentid, 
      ));
      
      if($rs->num_rows() >= 1)
      {
         $this->db->query('delete from item where issueitemid = ? and studentid = ? and receivedsessionid is null',array(
            $itemid,                   
            $studentid
         ));
         
      }
      else
      {
         $this->db->query('insert into item (studentid,issueitemid) values(?,?)',array(
            $studentid,
            $itemid                  
         ));
      }
   }
   
   public function toggle_all()
   {
      $schoolid = decuri($this->uri->segment(3));
      $issueitemid = $this->uri->segment(4);
      $onoff = $this->uri->segment(5);
      
      $students = $this->db->query('select studentid from student where schoolid = ?',array($schoolid));
      foreach($students->result() as $row)
      {
         $this->db->query('delete from item where issueitemid = ? and studentid = ? and receivedsessionid is null',array(
            $issueitemid,                   
            $row->studentid
         ));
         
         if($onoff == '1')
         {
            $this->db->query('insert into item (studentid,issueitemid) values(?,?)',array(
               $row->studentid,
               $issueitemid                  
            ));
         }
      }
   }
   
   public function list_school_students()
   {
      $schoolid = $this->uri->segment(3); 
      
      echo '<table class="display" id="tabledata">';
      echo '<thead>';
      echo '<tr>';
      echo '<th width="95"></th>';
      echo '<th>First Name</th>';
      echo '<th>Surname</th>';                 
      echo '<th>Birth Date</th>';
      echo '<th></th>';
      echo '</tr>';
      echo '</thead>';
      echo '<tbody>';
      
      $students = $this->db->query('select * from student where schoolid = ? and deleted is null',array($schoolid));
      foreach($students->result() as $row)
      {                        
         echo '<tr>';
         echo '<td>';
         echo '<ul class="toolbar clearfix fl">';
         echo '<li><a href="#" onclick="LinkStudentSelected(\'' . encuri($row->studentid) . '\')" title="Select Student" class="icon-only"><img src="/assets/images/navicons-small/92.png" alt=""/></a></li>';
         echo '</ul>';
         echo '</td>';
         echo '<td>' . $row->firstname . '</td>';
         echo '<td>' . $row->surname . '</td>';
         echo '<td>' . showdate($row->birthdate) . '</td>';
         echo '<td>';
         if($row->approvedon == '') echo '<span class="right red">(Cancelled)</span>';
         echo '</td>';
         echo '</tr>';
      }     
      echo '</tbody>';
      echo '</table>';                         
   }
   
   public function student_details()
   {
      $rs = $this->db->query('select *,date(birthdate) as formatteddob from student where studentid = ?',array(
         decuri($this->uri->segment(3))
      ));   
      $res['result'] = $rs->row(0);
      echo json_encode($res);         
      return;
   }   
   
   public function welcome_notices()
   {
       $this->db->query('delete from comm');
       $rs = $this->db->query('select studentid from student where not approvedon is null');
       $index = 0;
       foreach($rs->result() as $row)
       {
           send_welcome_notices($row->studentid);
           $index++;
       }
       echo $index . ' notice(s) generated<br />';
   }
    
}

/* End of file students.php */
/* Location: ./application/controllers/students.php */