<?php

function writeaudit($name, $detail)
{
   $ci =& get_instance(); 
   $ci->db->query('insert into audit (createdon, createdbyuserid, auditname, auditdetail) values(CURRENT_TIMESTAMP,?,?,?)',
      array($ci->session->userdata('user')->userid,
            $name,
            $detail
   ));   
}

function user()
{
   $ci =& get_instance();      
   return $ci->session->userdata('user');
}

function rsval($rs, $field)
{
   $ci =& get_instance();         
   if($rs == null) {       
      return $ci->input->post($field);
   }
   foreach($rs->result_array() as $row)
   {
      return $row[$field];
   }     
}

function lookup_options($lookupname, $selected)
{
   if(($lookupname == 'T-Shirt Size') && (($selected == null) || ($selected == '')))
      $selected = 7;
   
   $ci =& get_instance();
   $rs = $ci->db->query('select * from lookup where name = ? order by value',array($lookupname));
   foreach($rs->result() as $row)
   {
      if($selected == $row->lookupid)
         echo '<option value="' . $row->lookupid . '" selected>' . $row->value . '</option>';
      else
         echo '<option value="' . $row->lookupid . '">' . $row->value . '</option>';
   }
}

function coach_dropdown($selected)
{  
   $ci =& get_instance();
   $rs = $ci->db->query('select distinct u.userid,u.firstname,u.surname from user u inner join schoollink sl on sl.userid = u.userid inner join school s on s.schoolid = sl.schoolid  where u.deleted is null and (u.usertypeid = 3 or u.usertypeid = 4) order by u.firstname,u.surname');
   if($rs->num_rows() == 0)
      error_msg('No coaches found or no coaches linked to schools please check the database.');
   foreach($rs->result() as $row)
   {
      if($selected == $row->userid)
         echo '<option value="' . $row->userid . '" selected>' . $row->firstname . ' ' . $row->surname . '</option>';
      else
         echo '<option value="' . $row->userid . '">' . $row->firstname . ' ' . $row->surname . '</option>';
   }
}

function school_dropdown($selected, $coachid = null)
{
   $ci =& get_instance();
   if($coachid == null)
      $rs = $ci->db->query('select * from school where deleted is null order by schoolname');
   else
      $rs = $ci->db->query('select s.* from school s inner join schoollink sl on sl.schoolid = s.schoolid where s.deleted is null and sl.userid = ? order by schoolname',array($coachid));
   foreach($rs->result() as $row)
   {
      if($selected == $row->schoolid)
         echo '<option value="' . $row->schoolid . '" selected>' . $row->schoolname . '</option>';
      else
         echo '<option value="' . $row->schoolid . '">' . $row->schoolname . '</option>';
   }
}

function next_student_number($schoolid,$bump = 0)
{
   $ci =& get_instance();
   $rs = $ci->db->query('select studentnumbercode from school where schoolid = ?',array($schoolid));
   $last = $ci->db->query('select studentnumber from student where schoolid = ? order by studentid desc limit 0,1',array($schoolid));
   if($last->num_rows() == 0)
      $lastnum = 0;
   else
      $lastnum = (str_replace($rs->row(0)->studentnumbercode,'',$last->row(0)->studentnumber) * 1);
   
   $lastnum = $lastnum + 1;   
   $lastnum = $lastnum + $bump;
   
   return $rs->row(0)->studentnumbercode . $lastnum;   
}

function session_dropdown($coachid,$selected = null)
{
   $ci =& get_instance();
   $rs = $ci->db->query('select s.*,sc.codename from session s 
                         inner join schoollink sl on sl.schoolid = s.schoolid 
                         inner join school sc on sc.schoolid = sl.schoolid
                         where sl.userid = ? and s.sessionstartedon is null 
                         and s.sessionendedon is null
                         and s.sessiondate >= CURRENT_TIMESTAMP
                         ',array($coachid));
   foreach($rs->result() as $row)
   {
      $display = date('j M D',strtotime($row->sessiondate)) . ' ' . $row->starttime . ' - ' . $row->endtime . ' (' . $row->codename . ')';
      if($selected == $row->sessionid)
         echo '<option value="' . $row->sessionid . '" selected>' . $display . '</option>';
      else
         echo '<option value="' . $row->sessionid . '">' . $display . '</option>';
   }   
}

function get_items_to_issue($studentid)
{
   $ci =& get_instance(); 
   $rs = $ci->db->query('select * from item i inner join lookup l on l.lookupid = i.issueitemid where i.receivedsessionid is null and i.studentid = ?',
                  array($studentid
   ));   
   
   return $rs;
}

function item_in_list($rs,$field,$value)
{
   foreach($rs->result_array() as $row)
   {
      if($row[$field] == $value)
      {
         return true;
      }
   }
   return false;
}

function add_notification($schoolid,$studentid,$information)
{
   $ci =& get_instance();
   $rs = $ci->db->query('insert into notification (schoolid, studentid, information) values(?,?,?)',
            array($schoolid,
                  $studentid,
                  $information         
   ));
}

function school_has_notification($schoolid)
{
   $ci =& get_instance(); 
   if(user()->usertypeid == '3')
      return false;       
   $rs = $ci->db->query('select notificationid from notification where schoolid = ? and closed is null',array($schoolid));
   if($rs->num_rows() != 0)
      return true;
   else
      return false;
}

function all_students_cancelled($schoolid)
{
   $ci =& get_instance(); 
   $rs = $ci->db->query('select count(*) as total from student where schoolid = ? and not approvedon is null',array($schoolid));
   if($rs->row(0)->total == 0)
   {
      $rs = $ci->db->query('select count(*) as total from student where schoolid = ?',array($schoolid));   
      if($rs->row(0)->total != 0)
         return true;
      else
         return false;
   }
   else
      return false;
}

function student_has_notification($studentid)
{
   $ci =& get_instance(); 
   if(user()->usertypeid == '3')
      return false;       
   $rs = $ci->db->query('select notificationid from notification where studentid = ? and closed is null',array($studentid));
   if($rs->num_rows() != 0)
      return true;
   else
      return false;
}

function get_student_notification($studentid)
{
   $ci =& get_instance(); 
   $rs = $ci->db->query('select * from notification where studentid = ? and closed is null',array($studentid));
   $information = '';
   foreach($rs->result() as $row)
   {
      $information .= $row->information;
   }
   return $information;
}

function student_session_exists($sessionid,$studentid)
{
   $ci =& get_instance(); 
   $rs = $ci->db->query('select studentsessionid from studentsession where sessionid = ? and studentid = ?',array($sessionid,$studentid));
   if($rs->num_rows() == 1)
      return true;
   else
      return false;
}

function comm_email($to, $cc, $subject, $body)
{
   if(user() != null)
      $userid = user()->userid;
   else
      $userid = 0;
   $ci =& get_instance(); 
   $ci->db->query('insert into comm (createdbyuserid, createdon, emailto, emailcc, emailsubject, emailbody) values(?,CURRENT_TIMESTAMP,?,?,?,?)',
      array($userid,
            $to,
            $cc,
            $subject,
            $body
   ));
}

function comm_sms($smsnumber, $smsmessage)
{
   if(user() != null)
      $userid = user()->userid;
   else
      $userid = 0;   
   $ci =& get_instance(); 
   $ci->db->query('insert into comm (createdbyuserid, createdon, smsnumber, smsmessage) values(?,CURRENT_TIMESTAMP,?,?)',
      array($userid,
            $smsnumber,
            $smsmessage
   ));
}

function send_welcome_notices($studentid)
{
   $ci =& get_instance();
   $student = $ci->db->query('select * from student where studentid = ?',array($studentid));
   
   if($student->row(0)->paymentmethodid == 1){
       $email = $ci->load->view('templates/email_welcome_monthly',array(
          'student' => $student
       ),true);
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment.');
     }
   else if($student->row(0)->paymentmethodid == 2){
       $email = $ci->load->view('templates/email_welcome_quarterly',array(
          'student' => $student
       ),true);
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment. Quarterly Client');
     }
   else if($student->row(0)->paymentmethodid == 3){
       $email = $ci->load->view('templates/email_welcome_annual',array(
          'student' => $student
       ),true);   
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment. Annual Client.');
     }
   else if($student->row(0)->paymentmethodid == 4){
       $email = $ci->load->view('templates/email_welcome_debitorder_monthly',array(
          'student' => $student
       ),true);    
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment.Debit order Client');
     }
   else if($student->row(0)->paymentmethodid == 5){
       $email = $ci->load->view('templates/email_welcome_annual',array(
          'student' => $student
       ),true);       
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment. Annual Client.');
     }
   else if($student->row(0)->paymentmethodid == 17){
       $email = $ci->load->view('templates/email_welcome_debitorder_annual',array(
          'student' => $student
       ),true);       
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment. Debit order Client');
     }
   else if($student->row(0)->paymentmethodid == 18){
       $email = $ci->load->view('templates/email_welcome_debitorder_quarterly',array(
          'student' => $student
       ),true);    
       comm_sms(rsval($student,'parentcell'),'Welcome to RSD. Your acc nr: ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment. Debit order Client');
   }

   if(rsval($student,'parentemail') != null)
   {
      comm_email(rsval($student,'parentemail'),null,'Welcome to Rskills',$email);
   }
   /**********where to change the sms that is sent******/
   
   //comm_sms(rsval($student,'parentcell'),'Welcome to Rugga Kids 2016. Your acc no:  ' . rsval($student,'studentnumber') . '.Pls use as ref. When doing payment .Tel: 079 496 4597');
   
  
}

function new_if_empty($val)
{ 
   if($val == '')
      return 'new';
   else
      return encuri($val);
}

function number_of_students_perschool($schoolid)
{
   $ci =& get_instance();
   $student = $ci->db->query('select count(*) as total from student where schoolid = ? and not approvedon is null',array($schoolid));
   return $student->row(0)->total;
}

function number_of_cancelled_students_perschool($schoolid)
{
   $ci =& get_instance();
   $student = $ci->db->query('select count(*) as total from student where schoolid = ? and approvedon is null',array($schoolid));
   return $student->row(0)->total;
}

function number_of_students_percoach($coachid)
{
   $ci =& get_instance();
   $student = $ci->db->query('select count(*) as total 
                              from student s 
                              inner join school sc on sc.schoolid = s.schoolid 
                              inner join schoollink sl on sl.schoolid = s.schoolid                              
                              where sl.userid = ? and not s.approvedon is null',array($coachid));
   return $student->row(0)->total;
}

function get_coach_schools($coachid)
{
   $ci =& get_instance();
   $schools = $ci->db->query('select s.*
                              from schoollink sl 
                              inner join school s on sl.schoolid = s.schoolid                                                            
                              where sl.userid = ? and not s.approvedon is null',array($coachid));
   return $schools;
}


function get_school_coaches($schoolid)
{
   $ci =& get_instance();
   $coaches = $ci->db->query('select c.*
                              from schoollink sl 
                              inner join user c on c.userid = sl.userid
                              where sl.schoolid = ?',array($schoolid));
   return $coaches;
}

function student_paid($studentid)
{
   $ci =& get_instance();  
   $paid = $ci->db->query('select paid from studentsession where studentid = ?',array($studentid));
   if($paid->num_rows() == 0)
      return false;
   else if($paid->row(0)->paid == 1)
      return true;
   else
      return false;
}

function received_item($studentid,$issueitemid)
{
   $ci =& get_instance();  
   $item = $ci->db->query('select i.*,s.sessiondate 
                           from item i 
                           left join session s on s.sessionid = i.receivedsessionid
                           where i.studentid = ? and i.issueitemid = ? order by i.receivedsessionid desc',array($studentid,$issueitemid));
   return $item;
}

function get_student_attendance($studentid)
{
   $ci =& get_instance();  
   
   $rs = $ci->db->query('select ss.attending,s.notes2,s.sessiondate 
                           from studentsession ss
                           inner join session s on s.sessionid = ss.sessionid
                           where studentid = ?',array(
      $studentid
   ));
   return $rs;
}

function has_eval_score($evalvalues,$evalitemid,$score)
{
    foreach($evalvalues->result() as $row)
    {
        if(($row->evaluationitemid == $evalitemid) && ($row->value == $score))
            return true;
    }
    return false;
}

function nonull($str)
{
    if(($str == null) || ($str == 'null'))
        return '';
    else
        return $str;
}

function paymentmethodabbr($paymentmethodid)
{
    if($paymentmethodid == 1)  
        return 'M';
    else if($paymentmethodid == 2)  
        return 'Q';
    else if($paymentmethodid == 3)  
        return 'A';        
    else if($paymentmethodid == 4)  
        return 'DM';                
    else if($paymentmethodid == 17)  
        return 'DA';                        
    else if($paymentmethodid == 18)  
        return 'DQ';                                
}

function next_payment()
{
   global $last;
   $last = $last + 1;
   if($last == 1)
      echo '1st';
   else if($last == 2)
      echo '2nd';
   else if($last == 3)
      echo '3rd';      
   else if($last == 4)
      echo '4th';            
   else if($last == 5)
      echo '5th';                  
   else if($last == 6)
      echo '6th';                        
   else if($last == 7)
      echo '7th';                              
   else if($last == 8)
      echo '8th';                                    
   else if($last == 9)
      echo '9th';                                          
   else if($last == 10)
      echo '10th';                                                
   else if($last == 11)
      echo '11th';                                                
   else if($last == 12)
      echo '12th';                                                      
} 

function quarter() {
  return floor(((date('n') * 1) - 1) / 3) + 1;
}
  
?>