<?php

class Sms
{    
    function do_post_request($url, $data, $optional_headers = null)
    {
     $params = array('http' => array(
                  'method' => 'POST',
                  'content' => $data
               ));
     if ($optional_headers !== null) {
        $params['http']['header'] = $optional_headers;
     }
     $ctx = stream_context_create($params);
     $fp = @fopen($url, 'rb', false, $ctx);
     if (!$fp) {
        throw new Exception("Problem with $url, $php_errormsg");
     }
     $response = @stream_get_contents($fp);
     if ($response === false) {
        throw new Exception("Problem reading data from $url, $php_errormsg");
     }
     $response;
     return $this->formatXmlString($response);
     
    }
    
    function formatXmlString($xml) 
    {  
      
      // add marker linefeeds to aid the pretty-tokeniser (adds a linefeed between all tag-end boundaries)
      $xml = preg_replace('/(>)(<)(\/*)/', "$1\n$2$3", $xml);
      
      // now indent the tags
      $token      = strtok($xml, "\n");
      $result     = ''; // holds formatted version as it is built
      $pad        = 0; // initial indent
      $matches    = array(); // returns from preg_matches()
      
      // scan each line and adjust indent based on opening/closing tags
      while ($token !== false) : 
      
        // test for the various tag states
        
        // 1. open and closing tags on same line - no change
        if (preg_match('/.+<\/\w[^>]*>$/', $token, $matches)) : 
          $indent=0;
        // 2. closing tag - outdent now
        elseif (preg_match('/^<\/\w/', $token, $matches)) :
          $pad--;
        // 3. opening tag - don't pad this one, only subsequent tags
        elseif (preg_match('/^<\w[^>]*[^\/]>.*$/', $token, $matches)) :
          $indent=1;
        // 4. no indentation needed
        else :
          $indent = 0; 
        endif;
        
        // pad the line with the required number of leading spaces
        $line    = str_pad($token, strlen($token)+$pad, ' ', STR_PAD_LEFT);
        $result .= $line . "\n"; // add to the cumulative result, with linefeed
        $token   = strtok("\n"); // get the next token
        $pad    += $indent; // update the pad size for subsequent lines    
      endwhile; 
      
      return $result;
    }

    function SendSMS($to, $msg)
    {
        
        //This code block can be customised. 
        //The $data array contains data that must be modified as per the API documentation. The array contains data that you will post to the server
        $data= array(
        "Type"=> "sendparam", 
        "Username" => "Ruggakids",
        "Password" => "Ruggakids01",
        "live" => "true",
        "numto" => $to,
        "data1" => $msg
        ) ; //This contains data that you will send to the server.
        $data = http_build_query($data); //builds the post string ready for posting
        echo $this->do_post_request('http://www.mymobileapi.com/api5/http5.aspx', $data);  //Sends the post, and returns the result from the server.            
    }
}
  
/* End of file index.php */
/* Location: ./index.php */