<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Api extends CI_Controller {

  public function index()
  {        
        header("Location: /");      
  }
    
    public function students()
    {
        if($this->uri->segment(3) == 'fds22')
        {
            $province = '';
            $schoolfrom = '';
            $schoolto = '';
            
            if(isset($_GET['province']))
                $province = $_GET['province'];
            
            $province = str_replace('_',' ',$province);
                
            if(isset($_GET['schoolfrom']))
                $schoolfrom = $_GET['schoolfrom'];                
                
            if(isset($_GET['schoolto']))
                $schoolto = $_GET['schoolto'];                                
            
            $sql = 'select s.studentnumber,s.firstname,s.surname,sc.schoolname from student s 
                                    inner join school sc on sc.schoolid = s.schoolid
                                    where s.deleted is null and not s.approvedon is null ';
            
            if($province != '')
                $sql .= ' and sc.physicalprovince = \'' . $province . '\'';

            if($schoolfrom != '')
                $sql .= ' and left(sc.schoolname,1) >= \'' . $schoolfrom . '\'';                
                
            if($schoolto != '')
                $sql .= ' and left(sc.schoolname,1) <= \'' . $schoolto . '\'';                                
                                         
            $rs = $this->db->query($sql);  
                                                            
            //var_dump($rs->result_array());
            echo json_encode($rs->result_array());
        }
    }    
    
    public function studentfile()
    {
        if($this->uri->segment(3) == 'fds22')
        {
            $province = '';
            $schoolfrom = '';
            $schoolto = '';
                
            if(isset($_GET['province']))
                $province = $_GET['province'];
            
            $province = str_replace('_',' ',$province);
                
            if(isset($_GET['schoolfrom']))
                $schoolfrom = $_GET['schoolfrom'];                
                
            if(isset($_GET['schoolto']))
                $schoolto = $_GET['schoolto'];                                
            
            $sql = 'select * from student s 
                                    inner join school sc on sc.schoolid = s.schoolid
                                    where s.deleted is null and not s.approvedon is null ';
            
            if($province != '')
                $sql .= ' and sc.physicalprovince = \'' . $province . '\'';

            if($schoolfrom != '')
                $sql .= ' and left(sc.schoolname,1) >= \'' . $schoolfrom . '\'';                
                
            if($schoolto != '')
                $sql .= ' and left(sc.schoolname,1) <= \'' . $schoolto . '\'';                                
                                                
            $rs = $this->db->query($sql); 
            
            
            header("Content-Type: text/plain");
            header("Content-Disposition: Attachment; filename=invoices_import.txt");
            header("Pragma: no-cache");            
               
            foreach($rs->result() as $row)
            {
                echo '"' . str_replace(' ','',$row->studentnumber) . '",';
                echo '"' . safeexp($row->firstname) . ' ' . safeexp($row->surname) . ' (' . paymentmethodabbr($row->paymentmethodid) . ')",';
                echo '"",';
                echo '"",';
                echo '"",';
                echo '"",';
                echo '"",';
                echo '"' . safeexp($row->parentcell) . '",';
                echo '"",'; 
                echo '"' . safeexp($row->parentname) . '",';
                echo '"0",';
                echo '" 0",';
                echo '" 1",';
                echo '"     ",';
                echo '"",'; 
                echo '"",'; 
                echo '"",'; 
                echo '"",'; 
                echo '"",'; 
                echo '"N"," 0","N"," 1","N"," 1"," 0"," 0"," 0","User Defined 1  ","User Defined 2  ","User Defined 3  ","User Defined 4  ","User Defined 5  ",
                "                ","N","' . safeexp($row->parentcell) . '","'. safeexp($row->parentemail) . '"," 3"," 3","   ","          ","                "," 0","N","N"';
                
                echo "\r\n";
            }                                             
            
        }
    }    
    
    public function invoices()
    {
        if($this->uri->segment(3) == 'fds22')
        {        
            $province = '';
            $schoolfrom = '';
            $schoolto = '';
            
            if(isset($_GET['province']))
                $province = $_GET['province'];
            
            $province = str_replace('_',' ',$province);
                
            if(isset($_GET['schoolfrom']))
                $schoolfrom = $_GET['schoolfrom'];                
                
            if(isset($_GET['schoolto']))
                $schoolto = $_GET['schoolto'];                                
            
            $sql = 'select * from student s 
                                    inner join school sc on sc.schoolid = s.schoolid
                                    where s.deleted is null and not s.approvedon is null';
            
            if($province != '')
                $sql .= ' and sc.physicalprovince = \'' . $province . '\'';

            if($schoolfrom != '')
                $sql .= ' and left(sc.schoolname,1) >= \'' . $schoolfrom . '\'';                
                
            if($schoolto != '')
                $sql .= ' and left(sc.schoolname,1) <= \'' . $schoolto . '\'';                                
                           
            //$sql = $sql . ' limit 0,5 ';
            
            $rs = $this->db->query($sql);  
            
            header("Content-Type: text/plain");
            header("Content-Disposition: Attachment; filename=invoices_import.txt");
            header("Pragma: no-cache");
            
            $today = date('Y-m-d');
            
            foreach($rs->result() as $row)
            {
                if(($row->paymentmethodid == 1) || ($row->paymentmethodid == 4)) // Monthly
                {                            
                    $header = '"Header","INVIGN","N","N","' . str_replace(' ','',$row->studentnumber)  . '",' . getperiod($today) . ',"' . date('d/m/Y') . '",';
                    $header .= '"' . $row->studentnumber . "-" . date('Ym') . '","Y",0,';
                    $header .= '"' . $row->parentemail . '","","","","","","","","     ",0,"' . date('d/m/Y');
                    $header .= '","' . $row->parentcell . '","","' . $row->parentname . '",0,"","","N","N",';
                    echo $header . "\r\n";
                    
                    if(date('m') == '02')
                        $detail = '"Detail",0.00,1,420.00,420.00,"","00",0,0,"MF14","Monthly Fee 2016","4","","JHB"';
                    else
                        $detail = '"Detail",0.00,1,160.00,160.00,"","00",0,0,"MF14","Monthly Fee 2016","4","","JHB"';
                    echo $detail . "\r\n";
                }
                else if(($row->paymentmethodid == 2) || ($row->paymentmethodid == 18)) // Quarterly
                {         
                    if((date('m') == '01') || (date('m') == '02') || (date('m') == '03') || (date('m') == '06') || (date('m') == '09'))
                    {                      
                        $header = '"Header","INVIGN","N","N","' . str_replace(' ','',$row->studentnumber)  . '",' . getperiod($today) . ',"' . date('d/m/Y') . '",';
                        $header .= '"' . $row->studentnumber . "-" . date('Ym') . '","Y",0,';
                        $header .= '"' . $row->parentemail . '","","","","","","","","     ",0,"' . date('d/m/Y');
                        $header .= '","' . $row->parentcell . '","","' . $row->parentname . '",0,"","","N","N",';
                        echo $header . "\r\n";
                        
                        if((date('m') == '01') || (date('m') == '02') || (date('m') == '03') )
                            $detail = '"Detail",0.00,1,495.00,495.00,"","00",0,0,"QF14","Quarterly Fee 2016","4","","JHB"';
                        else
                            $detail = '"Detail",0.00,1,495.00,495.00,"","00",0,0,"QF14","Quarterly Fee 2016","4","","JHB"';
                        echo $detail . "\r\n";
                    }
                }
                else if(($row->paymentmethodid == 3) || ($row->paymentmethodid == 17)) // Anually
                {                     
                    if((date('m') == '01') || (date('m') == '02'))
                    {       
                        $header = '"Header","INVIGN","N","N","' . str_replace(' ','',$row->studentnumber)  . '",' . getperiod($today) . ',"' . date('d/m/Y') . '",';
                        $header .= '"' . $row->studentnumber . "-" . date('Ym') . '","Y",0,';
                        $header .= '"' . $row->parentemail . '","","","","","","","","     ",0,"' . date('d/m/Y');
                        $header .= '","' . $row->parentcell . '","","' . $row->parentname . '",0,"","","N","N",';
                        echo $header . "\r\n";
                        
                        $detail = '"Detail",0.00,1,1900.00,1900.00,"","00",0,0,"AF14","Annual Fee 2016","4","","JHB"';
                        echo $detail . "\r\n";
                    }
                }                
            }
            
            /*
            foreach($rs->result() as $row)
            {
                echo getperiod($today) . ",";
                echo "\"" . date('d/m/Y') . "\",";
                echo "\"D\",";
                echo "\"" . $row->studentnumber . "\",";
                echo "\"" . $row->studentnumber . "-" . date('Ym') . "\",";
                echo "\"Monthly Fee\",";
                echo "126.00,";
                echo "0,";
                echo "0,";
                echo "\"\",";
                echo "\"\",";
                echo "\"1000000\",";
                echo "1,";
                echo "1,";
                echo "0,";
                echo "0,";
                echo "0,";
                echo "0";   
                echo "\r\n";
            }*/                                                
             
        }      
    }
    
    public function testsms()
    {
        $sms = new Sms();
        $sms->SendSMS('27836564309','hello world');
    }
}

/* End of file api.php */
/* Location: ./application/controllers/api.php */