<!-- MAIN JAVASCRIPTS -->
<script type="text/javascript" src="/assets/js/jquery.tools.min.js"></script>
<script type="text/javascript" src="/assets/js/jquery.uniform.min.js"></script>
<script type="text/javascript" src="/assets/js/jquery.easing.js"></script>
<script type="text/javascript" src="/assets/js/jquery.ui.totop.js"></script>
<script type="text/javascript" src="/assets/js/jquery.itextsuggest.js"></script>
<script type="text/javascript" src="/assets/js/jquery.itextclear.js"></script>
<script type="text/javascript" src="/assets/js/jquery.hashchange.min.js"></script>
<script type="text/javascript" src="/assets/js/jquery.drilldownmenu.js"></script>
<script type="text/javascript" src="/assets/js/jquery.simplemodal-1.4.2.js"></script>
<script type="text/javascript" src="/assets/js/jquery.popover.js"></script>
<script type="text/javascript" src="/assets/lib/datatables/js/jquery.dataTables.js"></script> 

<!--[if lt IE 9]>
<script type="text/javascript" src="/assets/js/PIE.js"></script>
<script type="text/javascript" src="/assets/js/ie.js"></script>
<![endif]-->

<script type="text/javascript" src="/assets/js/global.js"></script>
<!-- MAIN JAVASCRIPTS END -->

<!-- LOADING SCRIPT -->
<script>
$(window).load(function(){
  $("#loading").fadeOut(function(){
      $(this).remove();
      $('body').removeAttr('style');
  });
});
</script>
<!-- LOADING SCRIPT -->

<!-- POPOVERS SETUP-->
<div id="activity-popover" class="popover">
  <header>
      Activity
  </header>
  <section>
      <div class="content">
          <nav>
              <ul>
                  <li class="new"><a><span class="avatar"></span>John Doe created a new project</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe created a new project</a></li>
                  <li class="read"><a><span class="avatar"></span>Jane Doe updated a project</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe uploaded a document</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe deleted a project</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe marked a project as done</a></li>
              </ul>
          </nav>
      </div>
  </section>
</div>
<div id="notifications-popover" class="popover">
  <header>
      Notifications
  </header>
  <section>
      <div class="content">
          <nav>
              <ul>
                  <li class="new"><a><span class="avatar"></span>John Doe created a new project</a></li>
                  <li class="new"><a><span class="avatar"></span>John Doe created a new project</a></li>
                  <li class="new"><a><span class="avatar"></span>Jane Doe updated a project</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe uploaded a document</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe deleted a project</a></li>
                  <li class="read"><a><span class="avatar"></span>John Doe marked a project as done</a></li>
                  <li><a href="#notifications.html" title="Notifications">See notification styles and growl like messages...</a></li>
              </ul>
          </nav>
      </div>
  </section>
</div>
<div id="settings-popover" class="popover">
  <header>
      Settings
  </header>
  <section>
      <div class="content">
          <nav>
              <ul>
                  <li><a>Project Settings</a></li>
                  <li><a>Account Settings</a></li>
              </ul>
          </nav>
      </div>
  </section>
</div>
<script>
  $(document).ready(function() {
      $('#activity-button').popover('#activity-popover', {preventRight: true});
      $('#notifications-button').popover('#notifications-popover', {preventRight: true});
      $('#settings-button').popover('#settings-popover', {preventRight: true});

      /**
       * setup search
       */
      function googleSearch(q){
          $('#searchform .searchbox a').fadeOut()
          $.ajax({
              url: 'php/google_search_results.php',
              data: 'q='+encodeURIComponent(q),
              cache: false,
              success: function(response){
                  $('.search_results').html(response);
              }
          });
      }

      // Set iTextSuggest
      $('#searchform .searchbox').length && $('#searchform .searchbox').find('input[type=text]').iTextClear().iTextSuggest({
          url: 'php/google_suggestions_results.php',
          onKeydown: function(query){
              googleSearch(query);
          },
          onChange: function(query){
              googleSearch(query);
          },
          onSelect: function(query){
              googleSearch(query);
          },
          onSubmit: function(query){
              googleSearch(query);
          },
          onEmpty: function(){
              $('.search_results').html('');
          }
      }).focus(function(){
          $('#wrapper > section > aside > nav > ul').fadeOut(function(){
              $('#searchform .search_results').show();
          });
          $(this).parents('#searchform .searchbox').animate({marginRight: 70}).next().fadeIn();
      });
      
      $('#searchform .searchcontainer').find('input[type=button]').click(function(){
          $('#searchform .search_results').hide();
          $('#searchform .searchbox').find('input[type=text]').val('');
          $('#searchform .search_results').html('');
          $('#wrapper > section > aside > nav > ul').fadeIn();
          $('.searchbox', $(this).parent()).animate({marginRight: 0}).next().fadeOut();
      });
      
      var section = $('#wrapper > section > section');
      section.css('width','auto');
      
      $("input:checkbox,input:radio,select,input:file").uniform();
      
      $('#tabledata').dataTable( {
        "bPaginate": false
      });
      
    $.tools.validator.fn("[type=time]", "Please supply a valid time", function (input, value) {
        return(/^\d\d:\d\d$/).test(value);
    });    

    $.tools.validator.fn("[data-equals]", "Value not equal with the $1 field", function (input) {
        var name = input.attr("data-equals"),
        field = this.getInputs().filter("[name=" + name + "]");
        return input.val() === field.val() ? true : [name];
    });

    $.tools.validator.fn("[minlength]", function (input, value) {
        var min = input.attr("minlength");

        return value.length >= min ? true : {
            en : "Please provide at least " + min + " character" + (min > 1 ? "s" : "")
        };
    });

    $("input[type=date]").dateinput({
         "format": "yyyy-mm-dd",
         "selectors": true,    
         "yearRange": [-20, 1]            
    });    
    
    $.tools.validator.localizeFn("[type=time]", {
        en : 'Please supply a valid time'
    });
    
    $(".has-validation").validator({
        position : 'bottom left',
        offset : [5, 0],
        messageClass : 'form-error',
        message : '<div><em/></div>'// em element is the arrow
    }).attr('novalidate', 'novalidate');          
      
      
    $(".tabs > ul").tabs("section > section");
    
    $(".timepicker").timepicker();
  });
</script>
<!-- POPOVERS SETUP END-->
</body>
</html>