/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0a_r701
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(j){j.jqplot.Cursor=function(r){this.style="crosshair";this.previousCursor="auto";this.show=j.jqplot.config.enablePlugins;this.showTooltip=true;this.followMouse=false;this.tooltipLocation="se";this.tooltipOffset=6;this.showTooltipGridPosition=false;this.showTooltipUnitPosition=true;this.showTooltipDataPosition=false;this.tooltipFormatString="%.4P, %.4P";this.useAxesFormatters=true;this.tooltipAxisGroups=[];this.zoom=false;this.zoomProxy=false;this.zoomTarget=false;this.clickReset=false;this.dblClickReset=true;this.showVerticalLine=false;this.showHorizontalLine=false;this.constrainZoomTo="none";this.shapeRenderer=new j.jqplot.ShapeRenderer();this._zoom={start:[],end:[],started:false,zooming:false,isZoomed:false,axes:{start:{},end:{}},gridpos:{},datapos:{}};this._tooltipElem;this.zoomCanvas;this.cursorCanvas;this.intersectionThreshold=2;this.showCursorLegend=false;this.cursorLegendFormatString=j.jqplot.Cursor.cursorLegendFormatString;this._oldHandlers={onselectstart:null,ondrag:null,onmousedown:null};this.constrainOutsideZoom=true;this.showTooltipOutsideZoom=false;this.onGrid=false;j.extend(true,this,r)};j.jqplot.Cursor.cursorLegendFormatString="%s x:%s, y:%s";j.jqplot.Cursor.init=function(v,u,t){var r=t||{};this.plugins.cursor=new j.jqplot.Cursor(r.cursor);var w=this.plugins.cursor;if(w.show){j.jqplot.eventListenerHooks.push(["jqplotMouseEnter",b]);j.jqplot.eventListenerHooks.push(["jqplotMouseLeave",f]);j.jqplot.eventListenerHooks.push(["jqplotMouseMove",i]);if(w.showCursorLegend){t.legend=t.legend||{};t.legend.renderer=j.jqplot.CursorLegendRenderer;t.legend.formatString=this.plugins.cursor.cursorLegendFormatString;t.legend.show=true}if(w.zoom){j.jqplot.eventListenerHooks.push(["jqplotMouseDown",a]);if(w.clickReset){j.jqplot.eventListenerHooks.push(["jqplotClick",k])}if(w.dblClickReset){j.jqplot.eventListenerHooks.push(["jqplotDblClick",c])}}this.resetZoom=function(){var z=this.axes;if(!w.zoomProxy){for(var y in z){z[y].reset()}this.redraw()}else{var x=this.plugins.cursor.zoomCanvas._ctx;x.clearRect(0,0,x.canvas.width,x.canvas.height);x=null}this.plugins.cursor._zoom.isZoomed=false;this.target.trigger("jqplotResetZoom",[this,this.plugins.cursor])};if(w.showTooltipDataPosition){w.showTooltipUnitPosition=false;w.showTooltipGridPosition=false;if(r.cursor.tooltipFormatString==undefined){w.tooltipFormatString=j.jqplot.Cursor.cursorLegendFormatString}}}};j.jqplot.Cursor.postDraw=function(){var x=this.plugins.cursor;x.zoomCanvas=new j.jqplot.GenericCanvas();this.eventCanvas._elem.before(x.zoomCanvas.createElement(this._gridPadding,"jqplot-zoom-canvas",this._plotDimensions));x.zoomCanvas.setContext();x._tooltipElem=j('<div class="jqplot-cursor-tooltip" style="position:absolute;display:none"></div>');x.zoomCanvas._elem.before(x._tooltipElem);if(x.showVerticalLine||x.showHorizontalLine){x.cursorCanvas=new j.jqplot.GenericCanvas();this.eventCanvas._elem.before(x.cursorCanvas.createElement(this._gridPadding,"jqplot-cursor-canvas",this._plotDimensions));x.cursorCanvas.setContext()}if(x.showTooltipUnitPosition){if(x.tooltipAxisGroups.length===0){var u=this.series;var v;var r=[];for(var t=0;t<u.length;t++){v=u[t];var w=v.xaxis+","+v.yaxis;if(j.inArray(w,r)==-1){r.push(w)}}for(var t=0;t<r.length;t++){x.tooltipAxisGroups.push(r[t].split(","))}}}};j.jqplot.Cursor.zoomProxy=function(x,t){var r=x.plugins.cursor;var w=t.plugins.cursor;r.zoomTarget=true;r.zoom=true;r.style="auto";r.dblClickReset=false;w.zoom=true;w.zoomProxy=true;t.target.bind("jqplotZoom",v);t.target.bind("jqplotResetZoom",u);function v(z,y,B,A,C){r.doZoom(y,B,x,C)}function u(y,z,A){x.resetZoom()}};j.jqplot.Cursor.prototype.resetZoom=function(w,x){var v=w.axes;var u=x._zoom.axes;if(!w.plugins.cursor.zoomProxy&&x._zoom.isZoomed){for(var t in v){v[t]._ticks=[];v[t].min=u[t].min;v[t].max=u[t].max;v[t].numberTicks=u[t].numberTicks;v[t].tickInterval=u[t].tickInterval;v[t].daTickInterval=u[t].daTickInterval}w.redraw();x._zoom.isZoomed=false}else{var r=x.zoomCanvas._ctx;r.clearRect(0,0,r.canvas.width,r.canvas.height);r=null}w.target.trigger("jqplotResetZoom",[w,x])};j.jqplot.Cursor.resetZoom=function(r){r.resetZoom()};j.jqplot.Cursor.prototype.doZoom=function(y,v,z,D){var B=D;var A=z.axes;var t=B._zoom.axes;var u=t.start;var w=t.end;var x,C;var E=z.plugins.cursor.zoomCanvas._ctx;if((B.constrainZoomTo=="none"&&Math.abs(y.x-B._zoom.start[0])>6&&Math.abs(y.y-B._zoom.start[1])>6)||(B.constrainZoomTo=="x"&&Math.abs(y.x-B._zoom.start[0])>6)||(B.constrainZoomTo=="y"&&Math.abs(y.y-B._zoom.start[1])>6)){if(!z.plugins.cursor.zoomProxy){for(var r in v){if(B._zoom.axes[r]==undefined){B._zoom.axes[r]={};B._zoom.axes[r].numberTicks=A[r].numberTicks;B._zoom.axes[r].tickInterval=A[r].tickInterval;B._zoom.axes[r].daTickInterval=A[r].daTickInterval;B._zoom.axes[r].min=A[r].min;B._zoom.axes[r].max=A[r].max}if((B.constrainZoomTo=="none")||(B.constrainZoomTo=="x"&&r.charAt(0)=="x")||(B.constrainZoomTo=="y"&&r.charAt(0)=="y")){dp=v[r];if(dp!=null){if(dp>u[r]){A[r].min=u[r];A[r].max=dp}else{span=u[r]-dp;A[r].max=u[r];A[r].min=dp}A[r].tickInterval=null;A[r].daTickInterval=null;A[r]._ticks=[]}}}E.clearRect(0,0,E.canvas.width,E.canvas.height);z.redraw();B._zoom.isZoomed=true;E=null}z.target.trigger("jqplotZoom",[y,v,z,D])}};j.jqplot.preInitHooks.push(j.jqplot.Cursor.init);j.jqplot.postDrawHooks.push(j.jqplot.Cursor.postDraw);function e(F,t,C){var H=C.plugins.cursor;var x="";var L=false;if(H.showTooltipGridPosition){x=F.x+", "+F.y;L=true}if(H.showTooltipUnitPosition){var E;for(var D=0;D<H.tooltipAxisGroups.length;D++){E=H.tooltipAxisGroups[D];if(L){x+="<br />"}if(H.useAxesFormatters){var B=C.axes[E[0]]._ticks[0].formatter;var r=C.axes[E[1]]._ticks[0].formatter;var I=C.axes[E[0]]._ticks[0].formatString;var w=C.axes[E[1]]._ticks[0].formatString;x+=B(I,t[E[0]])+", "+r(w,t[E[1]])}else{x+=j.jqplot.sprintf(H.tooltipFormatString,t[E[0]],t[E[1]])}L=true}}if(H.showTooltipDataPosition){var v=C.series;var K=d(C,F.x,F.y);var L=false;for(var D=0;D<v.length;D++){if(v[D].show){var z=v[D].index;var u=v[D].label.toString();var G=j.inArray(z,K.indices);var A=undefined;var y=undefined;if(G!=-1){var J=K.data[G].data;if(H.useAxesFormatters){var B=v[D]._xaxis._ticks[0].formatter;var r=v[D]._yaxis._ticks[0].formatter;var I=v[D]._xaxis._ticks[0].formatString;var w=v[D]._yaxis._ticks[0].formatString;A=B(I,J[0]);y=r(w,J[1])}else{A=J[0];y=J[1]}if(L){x+="<br />"}x+=j.jqplot.sprintf(H.tooltipFormatString,u,A,y);L=true}}}}H._tooltipElem.html(x)}function g(E,C){var G=C.plugins.cursor;var B=G.cursorCanvas._ctx;B.clearRect(0,0,B.canvas.width,B.canvas.height);if(G.showVerticalLine){G.shapeRenderer.draw(B,[[E.x,0],[E.x,B.canvas.height]])}if(G.showHorizontalLine){G.shapeRenderer.draw(B,[[0,E.y],[B.canvas.width,E.y]])}var I=d(C,E.x,E.y);if(G.showCursorLegend){var t=j(C.targetId+" td.jqplot-cursor-legend-label");for(var D=0;D<t.length;D++){var x=j(t[D]).data("seriesIndex");var v=C.series[x];var u=v.label.toString();var F=j.inArray(x,I.indices);var z=undefined;var y=undefined;if(F!=-1){var J=I.data[F].data;if(G.useAxesFormatters){var A=v._xaxis._ticks[0].formatter;var r=v._yaxis._ticks[0].formatter;var H=v._xaxis._ticks[0].formatString;var w=v._yaxis._ticks[0].formatString;z=A(H,J[0]);y=r(w,J[1])}else{z=J[0];y=J[1]}}if(C.legend.escapeHtml){j(t[D]).text(j.jqplot.sprintf(G.cursorLegendFormatString,u,z,y))}else{j(t[D]).html(j.jqplot.sprintf(G.cursorLegendFormatString,u,z,y))}}}B=null}function d(A,F,E){var B={indices:[],data:[]};var G,w,u,C,v,t;var z;var D=A.plugins.cursor;for(var w=0;w<A.series.length;w++){G=A.series[w];t=G.renderer;if(G.show){z=D.intersectionThreshold;if(G.showMarker){z+=G.markerRenderer.size/2}for(var v=0;v<G.gridData.length;v++){p=G.gridData[v];if(D.showVerticalLine){if(Math.abs(F-p[0])<=z){B.indices.push(w);B.data.push({seriesIndex:w,pointIndex:v,gridData:p,data:G.data[v]})}}}}}return B}function n(t,v){var z=v.plugins.cursor;var u=z._tooltipElem;switch(z.tooltipLocation){case"nw":var r=t.x+v._gridPadding.left-u.outerWidth(true)-z.tooltipOffset;var w=t.y+v._gridPadding.top-z.tooltipOffset-u.outerHeight(true);break;case"n":var r=t.x+v._gridPadding.left-u.outerWidth(true)/2;var w=t.y+v._gridPadding.top-z.tooltipOffset-u.outerHeight(true);break;case"ne":var r=t.x+v._gridPadding.left+z.tooltipOffset;var w=t.y+v._gridPadding.top-z.tooltipOffset-u.outerHeight(true);break;case"e":var r=t.x+v._gridPadding.left+z.tooltipOffset;var w=t.y+v._gridPadding.top-u.outerHeight(true)/2;break;case"se":var r=t.x+v._gridPadding.left+z.tooltipOffset;var w=t.y+v._gridPadding.top+z.tooltipOffset;break;case"s":var r=t.x+v._gridPadding.left-u.outerWidth(true)/2;var w=t.y+v._gridPadding.top+z.tooltipOffset;break;case"sw":var r=t.x+v._gridPadding.left-u.outerWidth(true)-z.tooltipOffset;var w=t.y+v._gridPadding.top+z.tooltipOffset;break;case"w":var r=t.x+v._gridPadding.left-u.outerWidth(true)-z.tooltipOffset;var w=t.y+v._gridPadding.top-u.outerHeight(true)/2;break;default:var r=t.x+v._gridPadding.left+z.tooltipOffset;var w=t.y+v._gridPadding.top+z.tooltipOffset;break}u.css("left",r);u.css("top",w);u=null}function m(w){var u=w._gridPadding;var x=w.plugins.cursor;var v=x._tooltipElem;switch(x.tooltipLocation){case"nw":var t=u.left+x.tooltipOffset;var r=u.top+x.tooltipOffset;v.css("left",t);v.css("top",r);break;case"n":var t=(u.left+(w._plotDimensions.width-u.right))/2-v.outerWidth(true)/2;var r=u.top+x.tooltipOffset;v.css("left",t);v.css("top",r);break;case"ne":var t=u.right+x.tooltipOffset;var r=u.top+x.tooltipOffset;v.css({right:t,top:r});break;case"e":var t=u.right+x.tooltipOffset;var r=(u.top+(w._plotDimensions.height-u.bottom))/2-v.outerHeight(true)/2;v.css({right:t,top:r});break;case"se":var t=u.right+x.tooltipOffset;var r=u.bottom+x.tooltipOffset;v.css({right:t,bottom:r});break;case"s":var t=(u.left+(w._plotDimensions.width-u.right))/2-v.outerWidth(true)/2;var r=u.bottom+x.tooltipOffset;v.css({left:t,bottom:r});break;case"sw":var t=u.left+x.tooltipOffset;var r=u.bottom+x.tooltipOffset;v.css({left:t,bottom:r});break;case"w":var t=u.left+x.tooltipOffset;var r=(u.top+(w._plotDimensions.height-u.bottom))/2-v.outerHeight(true)/2;v.css({left:t,top:r});break;default:var t=u.right-x.tooltipOffset;var r=u.bottom+x.tooltipOffset;v.css({right:t,bottom:r});break}v=null}function k(t,r,x,w,v){t.preventDefault();t.stopImmediatePropagation();var y=v.plugins.cursor;if(y.clickReset){y.resetZoom(v,y)}var u=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(u&&!u().isCollapsed){u().collapse()}}return false}function c(t,r,x,w,v){t.preventDefault();t.stopImmediatePropagation();var y=v.plugins.cursor;if(y.dblClickReset){y.resetZoom(v,y)}var u=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(u&&!u().isCollapsed){u().collapse()}}return false}function f(y,v,r,B,w){var x=w.plugins.cursor;x.onGrid=false;if(x.show){j(y.target).css("cursor",x.previousCursor);if(x.showTooltip&&!(x._zoom.zooming&&x.showTooltipOutsideZoom&&!x.constrainOutsideZoom)){x._tooltipElem.hide()}if(x.zoom){x._zoom.gridpos=v;x._zoom.datapos=r}if(x.showVerticalLine||x.showHorizontalLine){var D=x.cursorCanvas._ctx;D.clearRect(0,0,D.canvas.width,D.canvas.height);D=null}if(x.showCursorLegend){var C=j(w.targetId+" td.jqplot-cursor-legend-label");for(var u=0;u<C.length;u++){var A=j(C[u]).data("seriesIndex");var t=w.series[A];var z=t.label.toString();if(w.legend.escapeHtml){j(C[u]).text(j.jqplot.sprintf(x.cursorLegendFormatString,z,undefined,undefined))}else{j(C[u]).html(j.jqplot.sprintf(x.cursorLegendFormatString,z,undefined,undefined))}}}}}function b(t,r,w,v,u){var x=u.plugins.cursor;x.onGrid=true;if(x.show){x.previousCursor=t.target.style.cursor;t.target.style.cursor=x.style;if(x.showTooltip){e(r,w,u);if(x.followMouse){n(r,u)}else{m(u)}x._tooltipElem.show()}if(x.showVerticalLine||x.showHorizontalLine){g(r,u)}}}function i(u,t,x,w,v){var y=v.plugins.cursor;var r=y.zoomCanvas._ctx;if(y.show){if(y.showTooltip){e(t,x,v);if(y.followMouse){n(t,v)}}if(y.showVerticalLine||y.showHorizontalLine){g(t,v)}}r=null}function o(A){var z=A.data.plot;var v=z.eventCanvas._elem.offset();var y={x:A.pageX-v.left,y:A.pageY-v.top};var w={xaxis:null,yaxis:null,x2axis:null,y2axis:null,y3axis:null,y4axis:null,y5axis:null,y6axis:null,y7axis:null,y8axis:null,y9axis:null};var x=["xaxis","yaxis","x2axis","y2axis","y3axis","y4axis","y5axis","y6axis","y7axis","y8axis","y9axis"];var r=z.axes;var t,u;for(t=11;t>0;t--){u=x[t-1];if(r[u].show){w[u]=r[u].series_p2u(y[u.charAt(0)])}}return{offsets:v,gridPos:y,dataPos:w}}function h(B){var z=B.data.plot;var A=z.plugins.cursor;if(A.show&&A.zoom&&A._zoom.started&&!A.zoomTarget){var D=A.zoomCanvas._ctx;var x=o(B);var y=x.gridPos;var v=x.dataPos;A._zoom.gridpos=y;A._zoom.datapos=v;A._zoom.zooming=true;var w=y.x;var u=y.y;var C=D.canvas.height;var r=D.canvas.width;if(A.showTooltip&&!A.onGrid&&A.showTooltipOutsideZoom){e(y,v,z);if(A.followMouse){n(y,z)}}if(A.constrainZoomTo=="x"){A._zoom.end=[w,C]}else{if(A.constrainZoomTo=="y"){A._zoom.end=[r,u]}else{A._zoom.end=[w,u]}}var t=window.getSelection;if(document.selection&&document.selection.empty){document.selection.empty()}else{if(t&&!t().isCollapsed){t().collapse()}}l.call(A);D=null}}function a(y,u,t,z,v){var x=v.plugins.cursor;j(document).one("mouseup.jqplot_cursor",{plot:v},q);var w=v.axes;if(document.onselectstart!=undefined){x._oldHandlers.onselectstart=document.onselectstart;document.onselectstart=function(){return false}}if(document.ondrag!=undefined){x._oldHandlers.ondrag=document.ondrag;document.ondrag=function(){return false}}if(document.onmousedown!=undefined){x._oldHandlers.onmousedown=document.onmousedown;document.onmousedown=function(){return false}}if(x.zoom){if(!x.zoomProxy){var A=x.zoomCanvas._ctx;A.clearRect(0,0,A.canvas.width,A.canvas.height);A=null}if(x.constrainZoomTo=="x"){x._zoom.start=[u.x,0]}else{if(x.constrainZoomTo=="y"){x._zoom.start=[0,u.y]}else{x._zoom.start=[u.x,u.y]}}x._zoom.started=true;for(var r in t){x._zoom.axes.start[r]=t[r]}j(document).bind("mousemove.jqplotCursor",{plot:v},h)}}function q(A){var x=A.data.plot;var z=x.plugins.cursor;if(z.zoom&&z._zoom.zooming&&!z.zoomTarget){var w=z._zoom.gridpos.x;var t=z._zoom.gridpos.y;var v=z._zoom.datapos;var B=z.zoomCanvas._ctx.canvas.height;var r=z.zoomCanvas._ctx.canvas.width;var y=x.axes;if(z.constrainOutsideZoom&&!z.onGrid){if(w<0){w=0}else{if(w>r){w=r}}if(t<0){t=0}else{if(t>B){t=B}}for(var u in v){if(v[u]){if(u.charAt(0)=="x"){v[u]=y[u].series_p2u(w)}else{v[u]=y[u].series_p2u(t)}}}}if(z.constrainZoomTo=="x"){t=B}else{if(z.constrainZoomTo=="y"){w=r}}z._zoom.end=[w,t];z._zoom.gridpos={x:w,y:t};z.doZoom(z._zoom.gridpos,v,x,z)}z._zoom.started=false;z._zoom.zooming=false;j(document).unbind("mousemove.jqplotCursor",h);if(document.onselectstart!=undefined&&z._oldHandlers.onselectstart!=null){document.onselectstart=z._oldHandlers.onselectstart;z._oldHandlers.onselectstart=null}if(document.ondrag!=undefined&&z._oldHandlers.ondrag!=null){document.ondrag=z._oldHandlers.ondrag;z._oldHandlers.ondrag=null}if(document.onmousedown!=undefined&&z._oldHandlers.onmousedown!=null){document.onmousedown=z._oldHandlers.onmousedown;z._oldHandlers.onmousedown=null}}function l(){var A=this._zoom.start;var x=this._zoom.end;var v=this.zoomCanvas._ctx;var u,y,z,r;if(x[0]>A[0]){u=A[0];r=x[0]-A[0]}else{u=x[0];r=A[0]-x[0]}if(x[1]>A[1]){y=A[1];z=x[1]-A[1]}else{y=x[1];z=A[1]-x[1]}v.fillStyle="rgba(0,0,0,0.2)";v.strokeStyle="#999999";v.lineWidth=1;v.clearRect(0,0,v.canvas.width,v.canvas.height);v.fillRect(0,0,v.canvas.width,v.canvas.height);v.clearRect(u,y,r,z);v.strokeRect(u,y,r,z);v=null}j.jqplot.CursorLegendRenderer=function(r){j.jqplot.TableLegendRenderer.call(this,r);this.formatString="%s"};j.jqplot.CursorLegendRenderer.prototype=new j.jqplot.TableLegendRenderer();j.jqplot.CursorLegendRenderer.prototype.constructor=j.jqplot.CursorLegendRenderer;j.jqplot.CursorLegendRenderer.prototype.draw=function(){if(this.show){var w=this._series;this._elem=j('<table class="jqplot-legend jqplot-cursor-legend" style="position:absolute"></table>');var z=false;for(var v=0;v<w.length;v++){s=w[v];if(s.show){var r=j.jqplot.sprintf(this.formatString,s.label.toString());if(r){var t=s.color;if(s._stack&&!s.fill){t=""}x.call(this,r,t,z,v);z=true}for(var u=0;u<j.jqplot.addLegendRowHooks.length;u++){var y=j.jqplot.addLegendRowHooks[u].call(this,s);if(y){x.call(this,y.label,y.color,z);z=true}}}}}function x(D,C,F,A){var B=(F)?this.rowSpacing:"0";var E=j('<tr class="jqplot-legend jqplot-cursor-legend"></tr>').appendTo(this._elem);E.data("seriesIndex",A);j('<td class="jqplot-legend jqplot-cursor-legend-swatch" style="padding-top:'+B+';"><div style="border:1px solid #cccccc;padding:0.2em;"><div class="jqplot-cursor-legend-swatch" style="background-color:'+C+';"></div></div></td>').appendTo(E);var G=j('<td class="jqplot-legend jqplot-cursor-legend-label" style="vertical-align:middle;padding-top:'+B+';"></td>');G.appendTo(E);G.data("seriesIndex",A);if(this.escapeHtml){G.text(D)}else{G.html(D)}E=null;G=null}return this._elem}})(jQuery);